package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CruiseControlSpecBuilder extends io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.CruiseControlSpec,io.strimzi.api.kafka.model.CruiseControlSpecBuilder> {

    io.strimzi.api.kafka.model.CruiseControlSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CruiseControlSpecBuilder() {
        this(true);
    }

    public CruiseControlSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new CruiseControlSpec(), validationEnabled);
    }

    public CruiseControlSpecBuilder(io.strimzi.api.kafka.model.CruiseControlSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public CruiseControlSpecBuilder(io.strimzi.api.kafka.model.CruiseControlSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CruiseControlSpec(), validationEnabled);
    }

    public CruiseControlSpecBuilder(io.strimzi.api.kafka.model.CruiseControlSpecFluent<?> fluent,io.strimzi.api.kafka.model.CruiseControlSpec instance) {
        this(fluent, instance, true);
    }

    public CruiseControlSpecBuilder(io.strimzi.api.kafka.model.CruiseControlSpecFluent<?> fluent,io.strimzi.api.kafka.model.CruiseControlSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImage(instance.getImage());
        
        fluent.withTlsSidecar(instance.getTlsSidecar());
        
        fluent.withResources(instance.getResources());
        
        fluent.withLivenessProbe(instance.getLivenessProbe());
        
        fluent.withReadinessProbe(instance.getReadinessProbe());
        
        fluent.withJvmOptions(instance.getJvmOptions());
        
        fluent.withLogging(instance.getLogging());
        
        fluent.withTemplate(instance.getTemplate());
        
        fluent.withBrokerCapacity(instance.getBrokerCapacity());
        
        fluent.withConfig(instance.getConfig());
        
        fluent.withMetricsConfig(instance.getMetricsConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public CruiseControlSpecBuilder(io.strimzi.api.kafka.model.CruiseControlSpec instance) {
        this(instance,true);
    }

    public CruiseControlSpecBuilder(io.strimzi.api.kafka.model.CruiseControlSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withImage(instance.getImage());
        
        this.withTlsSidecar(instance.getTlsSidecar());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withLogging(instance.getLogging());
        
        this.withTemplate(instance.getTemplate());
        
        this.withBrokerCapacity(instance.getBrokerCapacity());
        
        this.withConfig(instance.getConfig());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.CruiseControlSpec build() {
        CruiseControlSpec buildable = new CruiseControlSpec();
        buildable.setImage(fluent.getImage());
        buildable.setTlsSidecar(fluent.getTlsSidecar());
        buildable.setResources(fluent.getResources());
        buildable.setLivenessProbe(fluent.getLivenessProbe());
        buildable.setReadinessProbe(fluent.getReadinessProbe());
        buildable.setJvmOptions(fluent.getJvmOptions());
        buildable.setLogging(fluent.getLogging());
        buildable.setTemplate(fluent.getTemplate());
        buildable.setBrokerCapacity(fluent.getBrokerCapacity());
        buildable.setConfig(fluent.getConfig());
        buildable.setMetricsConfig(fluent.getMetricsConfig());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CruiseControlSpecBuilder that = (CruiseControlSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
