package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityFluentImpl;
import io.strimzi.api.kafka.model.balancing.BrokerCapacity;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder;
import io.strimzi.api.kafka.model.template.CruiseControlTemplate;

public class CruiseControlSpecFluentImpl<A extends io.strimzi.api.kafka.model.CruiseControlSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent<A> {

    private java.lang.String image;
    private io.strimzi.api.kafka.model.TlsSidecarBuilder tlsSidecar;
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    private io.strimzi.api.kafka.model.ProbeBuilder livenessProbe;
    private io.strimzi.api.kafka.model.ProbeBuilder readinessProbe;
    private io.strimzi.api.kafka.model.JvmOptionsBuilder jvmOptions;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.Logging,?> logging;
    private io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder template;
    private io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder brokerCapacity;
    private java.util.Map<java.lang.String,java.lang.Object> config;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.MetricsConfig,?> metricsConfig;

    public CruiseControlSpecFluentImpl() {
    }

    public CruiseControlSpecFluentImpl(io.strimzi.api.kafka.model.CruiseControlSpec instance) {
        this.withImage(instance.getImage());
        
        this.withTlsSidecar(instance.getTlsSidecar());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withLogging(instance.getLogging());
        
        this.withTemplate(instance.getTemplate());
        
        this.withBrokerCapacity(instance.getBrokerCapacity());
        
        this.withConfig(instance.getConfig());
        
        this.withMetricsConfig(instance.getMetricsConfig());
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original) {
        return (A)withImage(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsSidecar instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.TlsSidecar getTlsSidecar() {
        return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public io.strimzi.api.kafka.model.TlsSidecar buildTlsSidecar() {
        return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public A withTlsSidecar(io.strimzi.api.kafka.model.TlsSidecar tlsSidecar) {
        _visitables.get("tlsSidecar").remove(this.tlsSidecar);
        if (tlsSidecar!=null){ this.tlsSidecar= new io.strimzi.api.kafka.model.TlsSidecarBuilder(tlsSidecar); _visitables.get("tlsSidecar").add(this.tlsSidecar);} return (A) this;
    }

    public java.lang.Boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TlsSidecarNested<A> withNewTlsSidecar() {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.TlsSidecarNestedImpl();
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(io.strimzi.api.kafka.model.TlsSidecar item) {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.TlsSidecarNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TlsSidecarNested<A> editTlsSidecar() {
        return withNewTlsSidecarLike(getTlsSidecar());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar() {
        return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): new io.strimzi.api.kafka.model.TlsSidecarBuilder().build());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(io.strimzi.api.kafka.model.TlsSidecar item) {
        return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): item);
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public java.lang.Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.LivenessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.LivenessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public java.lang.Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.ReadinessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.ReadinessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJvmOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JvmOptions getJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public io.strimzi.api.kafka.model.JvmOptions buildJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(io.strimzi.api.kafka.model.JvmOptions jvmOptions) {
        _visitables.get("jvmOptions").remove(this.jvmOptions);
        if (jvmOptions!=null){ this.jvmOptions= new io.strimzi.api.kafka.model.JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public java.lang.Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.JvmOptionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.JvmOptionsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new io.strimzi.api.kafka.model.JvmOptionsBuilder().build());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Logging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public io.strimzi.api.kafka.model.Logging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(io.strimzi.api.kafka.model.Logging logging) {
        if (logging instanceof io.strimzi.api.kafka.model.ExternalLogging){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder((io.strimzi.api.kafka.model.ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
        if (logging instanceof io.strimzi.api.kafka.model.InlineLogging){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder((io.strimzi.api.kafka.model.InlineLogging)logging); _visitables.get("logging").add(this.logging);}
        return (A) this;
    }

    public java.lang.Boolean hasLogging() {
        return this.logging != null;
    }

    public A withExternalLogging(io.strimzi.api.kafka.model.ExternalLogging externalLogging) {
        _visitables.get("logging").remove(this.logging);
        if (externalLogging!=null){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.ExternalLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(io.strimzi.api.kafka.model.ExternalLogging item) {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(io.strimzi.api.kafka.model.InlineLogging inlineLogging) {
        _visitables.get("logging").remove(this.logging);
        if (inlineLogging!=null){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.InlineLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(io.strimzi.api.kafka.model.InlineLogging item) {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.InlineLoggingNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.CruiseControlTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.CruiseControlTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.CruiseControlTemplate item) {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.CruiseControlTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBrokerCapacity instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.balancing.BrokerCapacity getBrokerCapacity() {
        return this.brokerCapacity!=null?this.brokerCapacity.build():null;
    }

    public io.strimzi.api.kafka.model.balancing.BrokerCapacity buildBrokerCapacity() {
        return this.brokerCapacity!=null?this.brokerCapacity.build():null;
    }

    public A withBrokerCapacity(io.strimzi.api.kafka.model.balancing.BrokerCapacity brokerCapacity) {
        _visitables.get("brokerCapacity").remove(this.brokerCapacity);
        if (brokerCapacity!=null){ this.brokerCapacity= new io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder(brokerCapacity); _visitables.get("brokerCapacity").add(this.brokerCapacity);} return (A) this;
    }

    public java.lang.Boolean hasBrokerCapacity() {
        return this.brokerCapacity != null;
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.BrokerCapacityNested<A> withNewBrokerCapacity() {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.BrokerCapacityNestedImpl();
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.BrokerCapacityNested<A> withNewBrokerCapacityLike(io.strimzi.api.kafka.model.balancing.BrokerCapacity item) {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.BrokerCapacityNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.BrokerCapacityNested<A> editBrokerCapacity() {
        return withNewBrokerCapacityLike(getBrokerCapacity());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.BrokerCapacityNested<A> editOrNewBrokerCapacity() {
        return withNewBrokerCapacityLike(getBrokerCapacity() != null ? getBrokerCapacity(): new io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder().build());
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.BrokerCapacityNested<A> editOrNewBrokerCapacityLike(io.strimzi.api.kafka.model.balancing.BrokerCapacity item) {
        return withNewBrokerCapacityLike(getBrokerCapacity() != null ? getBrokerCapacity(): item);
    }

    public A addToConfig(java.lang.String key,java.lang.Object value) {
        if(this.config == null && key != null && value != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null && map != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(java.lang.String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getConfig() {
        return this.config;
    }

    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(config);} return (A) this;
    }

    public java.lang.Boolean hasConfig() {
        return this.config != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetricsConfig instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.MetricsConfig getMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public io.strimzi.api.kafka.model.MetricsConfig buildMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public A withMetricsConfig(io.strimzi.api.kafka.model.MetricsConfig metricsConfig) {
        if (metricsConfig instanceof io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder((io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics)metricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);}
        return (A) this;
    }

    public java.lang.Boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public A withJmxPrometheusExporterMetricsConfig(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig) {
        _visitables.get("metricsConfig").remove(this.metricsConfig);
        if (jmxPrometheusExporterMetricsConfig!=null){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);} return (A) this;
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    public io.strimzi.api.kafka.model.CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
        return new io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CruiseControlSpecFluentImpl that = (CruiseControlSpecFluentImpl) o;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (tlsSidecar != null ? !tlsSidecar.equals(that.tlsSidecar) :that.tlsSidecar != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        if (brokerCapacity != null ? !brokerCapacity.equals(that.brokerCapacity) :that.brokerCapacity != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (metricsConfig != null ? !metricsConfig.equals(that.metricsConfig) :that.metricsConfig != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(image,  tlsSidecar,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  logging,  template,  brokerCapacity,  config,  metricsConfig,  super.hashCode());
    }

      
  /**
   * Representation of a TLS sidecar container configuration
   */
  public class TlsSidecarNestedImpl<N> extends io.strimzi.api.kafka.model.TlsSidecarFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecFluent.TlsSidecarNested<N>> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent.TlsSidecarNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.TlsSidecarBuilder builder;

            TlsSidecarNestedImpl(io.strimzi.api.kafka.model.TlsSidecar item) {
                this.builder = new io.strimzi.api.kafka.model.TlsSidecarBuilder(this, item);
                        
            }

            TlsSidecarNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.TlsSidecarBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withTlsSidecar(builder.build());
            }

            public N endTlsSidecar() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class LivenessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecFluent.LivenessProbeNested<N>> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            LivenessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ReadinessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecFluent.ReadinessProbeNested<N>> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            ReadinessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


      
  /**
   * Representation for options to be passed to a JVM.
   */
  public class JvmOptionsNestedImpl<N> extends io.strimzi.api.kafka.model.JvmOptionsFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecFluent.JvmOptionsNested<N>> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JvmOptionsBuilder builder;

            JvmOptionsNestedImpl(io.strimzi.api.kafka.model.JvmOptions item) {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this, item);
                        
            }

            JvmOptionsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withJvmOptions(builder.build());
            }

            public N endJvmOptions() {
                return and();
            }
    }


      
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public class ExternalLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.ExternalLoggingFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecFluent.ExternalLoggingNested<N>> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ExternalLoggingBuilder builder;

            ExternalLoggingNestedImpl(io.strimzi.api.kafka.model.ExternalLogging item) {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this, item);
                        
            }

            ExternalLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endExternalLogging() {
                return and();
            }
    }


      
  /**
   * Logging config is given inline with the resource
   */
  public class InlineLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.InlineLoggingFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecFluent.InlineLoggingNested<N>> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.InlineLoggingBuilder builder;

            InlineLoggingNestedImpl(io.strimzi.api.kafka.model.InlineLogging item) {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this, item);
                        
            }

            InlineLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endInlineLogging() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Cruise Control resources.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.CruiseControlTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


      
  /**
   * Representation of the Cruise Control broker capacity settings. Since the Kafka brokers
   * in Strimzi are homogeneous, the capacity values for each resource will be
   * used for every broker.
   */
  public class BrokerCapacityNestedImpl<N> extends io.strimzi.api.kafka.model.balancing.BrokerCapacityFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecFluent.BrokerCapacityNested<N>> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent.BrokerCapacityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder builder;

            BrokerCapacityNestedImpl(io.strimzi.api.kafka.model.balancing.BrokerCapacity item) {
                this.builder = new io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder(this, item);
                        
            }

            BrokerCapacityNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withBrokerCapacity(builder.build());
            }

            public N endBrokerCapacity() {
                return and();
            }
    }


      
  /**
   * JMX Prometheus Exporter metrics config
   */
  public class JmxPrometheusExporterMetricsConfigNestedImpl<N> extends io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluentImpl<io.strimzi.api.kafka.model.CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> implements io.strimzi.api.kafka.model.CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder builder;

            JmxPrometheusExporterMetricsConfigNestedImpl(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this, item);
                        
            }

            JmxPrometheusExporterMetricsConfigNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withMetricsConfig(builder.build());
            }

            public N endJmxPrometheusExporterMetricsConfig() {
                return and();
            }
    }


}
