package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of the Entity Operator deployment.
   */
  public class EntityOperatorSpecBuilder extends io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl<io.strimzi.api.kafka.model.EntityOperatorSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.EntityOperatorSpec,io.strimzi.api.kafka.model.EntityOperatorSpecBuilder> {

    io.strimzi.api.kafka.model.EntityOperatorSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EntityOperatorSpecBuilder() {
        this(true);
    }

    public EntityOperatorSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new EntityOperatorSpec(), validationEnabled);
    }

    public EntityOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityOperatorSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public EntityOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityOperatorSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EntityOperatorSpec(), validationEnabled);
    }

    public EntityOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityOperatorSpecFluent<?> fluent,io.strimzi.api.kafka.model.EntityOperatorSpec instance) {
        this(fluent, instance, true);
    }

    public EntityOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityOperatorSpecFluent<?> fluent,io.strimzi.api.kafka.model.EntityOperatorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTopicOperator(instance.getTopicOperator());
        
        fluent.withUserOperator(instance.getUserOperator());
        
        fluent.withTlsSidecar(instance.getTlsSidecar());
        
        fluent.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public EntityOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityOperatorSpec instance) {
        this(instance,true);
    }

    public EntityOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityOperatorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withTopicOperator(instance.getTopicOperator());
        
        this.withUserOperator(instance.getUserOperator());
        
        this.withTlsSidecar(instance.getTlsSidecar());
        
        this.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpec build() {
        EntityOperatorSpec buildable = new EntityOperatorSpec();
        buildable.setTopicOperator(fluent.getTopicOperator());
        buildable.setUserOperator(fluent.getUserOperator());
        buildable.setTlsSidecar(fluent.getTlsSidecar());
        buildable.setTemplate(fluent.getTemplate());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EntityOperatorSpecBuilder that = (EntityOperatorSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
