package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder;
import io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.template.EntityOperatorTemplate;
import java.lang.Object;

  
  /**
   * Representation of the Entity Operator deployment.
   */
  public class EntityOperatorSpecFluentImpl<A extends io.strimzi.api.kafka.model.EntityOperatorSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.EntityOperatorSpecFluent<A> {

    private io.strimzi.api.kafka.model.EntityTopicOperatorSpecBuilder topicOperator;
    private io.strimzi.api.kafka.model.EntityUserOperatorSpecBuilder userOperator;
    private io.strimzi.api.kafka.model.TlsSidecarBuilder tlsSidecar;
    private io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder template;

    public EntityOperatorSpecFluentImpl() {
    }

    public EntityOperatorSpecFluentImpl(io.strimzi.api.kafka.model.EntityOperatorSpec instance) {
        this.withTopicOperator(instance.getTopicOperator());
        
        this.withUserOperator(instance.getUserOperator());
        
        this.withTlsSidecar(instance.getTlsSidecar());
        
        this.withTemplate(instance.getTemplate());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTopicOperator instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.EntityTopicOperatorSpec getTopicOperator() {
        return this.topicOperator!=null?this.topicOperator.build():null;
    }

    public io.strimzi.api.kafka.model.EntityTopicOperatorSpec buildTopicOperator() {
        return this.topicOperator!=null?this.topicOperator.build():null;
    }

    public A withTopicOperator(io.strimzi.api.kafka.model.EntityTopicOperatorSpec topicOperator) {
        _visitables.get("topicOperator").remove(this.topicOperator);
        if (topicOperator!=null){ this.topicOperator= new io.strimzi.api.kafka.model.EntityTopicOperatorSpecBuilder(topicOperator); _visitables.get("topicOperator").add(this.topicOperator);} return (A) this;
    }

    public java.lang.Boolean hasTopicOperator() {
        return this.topicOperator != null;
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TopicOperatorNested<A> withNewTopicOperator() {
        return new io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl.TopicOperatorNestedImpl();
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TopicOperatorNested<A> withNewTopicOperatorLike(io.strimzi.api.kafka.model.EntityTopicOperatorSpec item) {
        return new io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl.TopicOperatorNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TopicOperatorNested<A> editTopicOperator() {
        return withNewTopicOperatorLike(getTopicOperator());
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TopicOperatorNested<A> editOrNewTopicOperator() {
        return withNewTopicOperatorLike(getTopicOperator() != null ? getTopicOperator(): new io.strimzi.api.kafka.model.EntityTopicOperatorSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TopicOperatorNested<A> editOrNewTopicOperatorLike(io.strimzi.api.kafka.model.EntityTopicOperatorSpec item) {
        return withNewTopicOperatorLike(getTopicOperator() != null ? getTopicOperator(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildUserOperator instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.EntityUserOperatorSpec getUserOperator() {
        return this.userOperator!=null?this.userOperator.build():null;
    }

    public io.strimzi.api.kafka.model.EntityUserOperatorSpec buildUserOperator() {
        return this.userOperator!=null?this.userOperator.build():null;
    }

    public A withUserOperator(io.strimzi.api.kafka.model.EntityUserOperatorSpec userOperator) {
        _visitables.get("userOperator").remove(this.userOperator);
        if (userOperator!=null){ this.userOperator= new io.strimzi.api.kafka.model.EntityUserOperatorSpecBuilder(userOperator); _visitables.get("userOperator").add(this.userOperator);} return (A) this;
    }

    public java.lang.Boolean hasUserOperator() {
        return this.userOperator != null;
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.UserOperatorNested<A> withNewUserOperator() {
        return new io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl.UserOperatorNestedImpl();
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.UserOperatorNested<A> withNewUserOperatorLike(io.strimzi.api.kafka.model.EntityUserOperatorSpec item) {
        return new io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl.UserOperatorNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.UserOperatorNested<A> editUserOperator() {
        return withNewUserOperatorLike(getUserOperator());
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.UserOperatorNested<A> editOrNewUserOperator() {
        return withNewUserOperatorLike(getUserOperator() != null ? getUserOperator(): new io.strimzi.api.kafka.model.EntityUserOperatorSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.UserOperatorNested<A> editOrNewUserOperatorLike(io.strimzi.api.kafka.model.EntityUserOperatorSpec item) {
        return withNewUserOperatorLike(getUserOperator() != null ? getUserOperator(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsSidecar instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.TlsSidecar getTlsSidecar() {
        return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public io.strimzi.api.kafka.model.TlsSidecar buildTlsSidecar() {
        return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public A withTlsSidecar(io.strimzi.api.kafka.model.TlsSidecar tlsSidecar) {
        _visitables.get("tlsSidecar").remove(this.tlsSidecar);
        if (tlsSidecar!=null){ this.tlsSidecar= new io.strimzi.api.kafka.model.TlsSidecarBuilder(tlsSidecar); _visitables.get("tlsSidecar").add(this.tlsSidecar);} return (A) this;
    }

    public java.lang.Boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TlsSidecarNested<A> withNewTlsSidecar() {
        return new io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl.TlsSidecarNestedImpl();
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(io.strimzi.api.kafka.model.TlsSidecar item) {
        return new io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl.TlsSidecarNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TlsSidecarNested<A> editTlsSidecar() {
        return withNewTlsSidecarLike(getTlsSidecar());
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar() {
        return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): new io.strimzi.api.kafka.model.TlsSidecarBuilder().build());
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(io.strimzi.api.kafka.model.TlsSidecar item) {
        return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.EntityOperatorTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.EntityOperatorTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.EntityOperatorTemplate item) {
        return new io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.EntityOperatorTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EntityOperatorSpecFluentImpl that = (EntityOperatorSpecFluentImpl) o;
        if (topicOperator != null ? !topicOperator.equals(that.topicOperator) :that.topicOperator != null) return false;
        if (userOperator != null ? !userOperator.equals(that.userOperator) :that.userOperator != null) return false;
        if (tlsSidecar != null ? !tlsSidecar.equals(that.tlsSidecar) :that.tlsSidecar != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(topicOperator,  userOperator,  tlsSidecar,  template,  super.hashCode());
    }

      
  /**
   * Representation of a Strimzi-managed Topic Operator deployment.
   */
  public class TopicOperatorNestedImpl<N> extends io.strimzi.api.kafka.model.EntityTopicOperatorSpecFluentImpl<io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TopicOperatorNested<N>> implements io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TopicOperatorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.EntityTopicOperatorSpecBuilder builder;

            TopicOperatorNestedImpl(io.strimzi.api.kafka.model.EntityTopicOperatorSpec item) {
                this.builder = new io.strimzi.api.kafka.model.EntityTopicOperatorSpecBuilder(this, item);
                        
            }

            TopicOperatorNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.EntityTopicOperatorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorSpecFluentImpl.this.withTopicOperator(builder.build());
            }

            public N endTopicOperator() {
                return and();
            }
    }


      
  /**
   * Representation of the User Operator.
   */
  public class UserOperatorNestedImpl<N> extends io.strimzi.api.kafka.model.EntityUserOperatorSpecFluentImpl<io.strimzi.api.kafka.model.EntityOperatorSpecFluent.UserOperatorNested<N>> implements io.strimzi.api.kafka.model.EntityOperatorSpecFluent.UserOperatorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.EntityUserOperatorSpecBuilder builder;

            UserOperatorNestedImpl(io.strimzi.api.kafka.model.EntityUserOperatorSpec item) {
                this.builder = new io.strimzi.api.kafka.model.EntityUserOperatorSpecBuilder(this, item);
                        
            }

            UserOperatorNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.EntityUserOperatorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorSpecFluentImpl.this.withUserOperator(builder.build());
            }

            public N endUserOperator() {
                return and();
            }
    }


      
  /**
   * Representation of a TLS sidecar container configuration
   */
  public class TlsSidecarNestedImpl<N> extends io.strimzi.api.kafka.model.TlsSidecarFluentImpl<io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TlsSidecarNested<N>> implements io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TlsSidecarNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.TlsSidecarBuilder builder;

            TlsSidecarNestedImpl(io.strimzi.api.kafka.model.TlsSidecar item) {
                this.builder = new io.strimzi.api.kafka.model.TlsSidecarBuilder(this, item);
                        
            }

            TlsSidecarNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.TlsSidecarBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorSpecFluentImpl.this.withTlsSidecar(builder.build());
            }

            public N endTlsSidecar() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Entity Operator resources.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl<io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.EntityOperatorSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.EntityOperatorTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


}
