package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of the User Operator.
   */
  public class EntityUserOperatorSpecBuilder extends io.strimzi.api.kafka.model.EntityUserOperatorSpecFluentImpl<io.strimzi.api.kafka.model.EntityUserOperatorSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.EntityUserOperatorSpec,io.strimzi.api.kafka.model.EntityUserOperatorSpecBuilder> {

    io.strimzi.api.kafka.model.EntityUserOperatorSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EntityUserOperatorSpecBuilder() {
        this(true);
    }

    public EntityUserOperatorSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new EntityUserOperatorSpec(), validationEnabled);
    }

    public EntityUserOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityUserOperatorSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public EntityUserOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityUserOperatorSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EntityUserOperatorSpec(), validationEnabled);
    }

    public EntityUserOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityUserOperatorSpecFluent<?> fluent,io.strimzi.api.kafka.model.EntityUserOperatorSpec instance) {
        this(fluent, instance, true);
    }

    public EntityUserOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityUserOperatorSpecFluent<?> fluent,io.strimzi.api.kafka.model.EntityUserOperatorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withWatchedNamespace(instance.getWatchedNamespace());
        
        fluent.withImage(instance.getImage());
        
        fluent.withSecretPrefix(instance.getSecretPrefix());
        
        fluent.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
        
        fluent.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
        
        fluent.withLivenessProbe(instance.getLivenessProbe());
        
        fluent.withReadinessProbe(instance.getReadinessProbe());
        
        fluent.withResources(instance.getResources());
        
        fluent.withLogging(instance.getLogging());
        
        fluent.withJvmOptions(instance.getJvmOptions());
        
        this.validationEnabled = validationEnabled; 
    }

    public EntityUserOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityUserOperatorSpec instance) {
        this(instance,true);
    }

    public EntityUserOperatorSpecBuilder(io.strimzi.api.kafka.model.EntityUserOperatorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withWatchedNamespace(instance.getWatchedNamespace());
        
        this.withImage(instance.getImage());
        
        this.withSecretPrefix(instance.getSecretPrefix());
        
        this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
        
        this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withResources(instance.getResources());
        
        this.withLogging(instance.getLogging());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.EntityUserOperatorSpec build() {
        EntityUserOperatorSpec buildable = new EntityUserOperatorSpec();
        buildable.setWatchedNamespace(fluent.getWatchedNamespace());
        buildable.setImage(fluent.getImage());
        buildable.setSecretPrefix(fluent.getSecretPrefix());
        buildable.setReconciliationIntervalSeconds(fluent.getReconciliationIntervalSeconds());
        buildable.setZookeeperSessionTimeoutSeconds(fluent.getZookeeperSessionTimeoutSeconds());
        buildable.setLivenessProbe(fluent.getLivenessProbe());
        buildable.setReadinessProbe(fluent.getReadinessProbe());
        buildable.setResources(fluent.getResources());
        buildable.setLogging(fluent.getLogging());
        buildable.setJvmOptions(fluent.getJvmOptions());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EntityUserOperatorSpecBuilder that = (EntityUserOperatorSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
