package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for a value read from a given key of a config map in the same namespace as the referrer.
   */
  public class ExternalConfigurationReferenceBuilder extends io.strimzi.api.kafka.model.ExternalConfigurationReferenceFluentImpl<io.strimzi.api.kafka.model.ExternalConfigurationReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.ExternalConfigurationReference,io.strimzi.api.kafka.model.ExternalConfigurationReferenceBuilder> {

    io.strimzi.api.kafka.model.ExternalConfigurationReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExternalConfigurationReferenceBuilder() {
        this(true);
    }

    public ExternalConfigurationReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new ExternalConfigurationReference(), validationEnabled);
    }

    public ExternalConfigurationReferenceBuilder(io.strimzi.api.kafka.model.ExternalConfigurationReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalConfigurationReferenceBuilder(io.strimzi.api.kafka.model.ExternalConfigurationReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExternalConfigurationReference(), validationEnabled);
    }

    public ExternalConfigurationReferenceBuilder(io.strimzi.api.kafka.model.ExternalConfigurationReferenceFluent<?> fluent,io.strimzi.api.kafka.model.ExternalConfigurationReference instance) {
        this(fluent, instance, true);
    }

    public ExternalConfigurationReferenceBuilder(io.strimzi.api.kafka.model.ExternalConfigurationReferenceFluent<?> fluent,io.strimzi.api.kafka.model.ExternalConfigurationReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationReferenceBuilder(io.strimzi.api.kafka.model.ExternalConfigurationReference instance) {
        this(instance,true);
    }

    public ExternalConfigurationReferenceBuilder(io.strimzi.api.kafka.model.ExternalConfigurationReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.ExternalConfigurationReference build() {
        ExternalConfigurationReference buildable = new ExternalConfigurationReference();
        buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalConfigurationReferenceBuilder that = (ExternalConfigurationReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
