package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

  
  /**
   * Representation for a value read from a given key of a config map in the same namespace as the referrer.
   */
  public class ExternalConfigurationReferenceFluentImpl<A extends io.strimzi.api.kafka.model.ExternalConfigurationReferenceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.ExternalConfigurationReferenceFluent<A> {

    private io.fabric8.kubernetes.api.model.ConfigMapKeySelector configMapKeyRef;

    public ExternalConfigurationReferenceFluentImpl() {
    }

    public ExternalConfigurationReferenceFluentImpl(io.strimzi.api.kafka.model.ExternalConfigurationReference instance) {
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
    }

    public io.fabric8.kubernetes.api.model.ConfigMapKeySelector getConfigMapKeyRef() {
        return this.configMapKeyRef;
    }

    public A withConfigMapKeyRef(io.fabric8.kubernetes.api.model.ConfigMapKeySelector configMapKeyRef) {
        this.configMapKeyRef=configMapKeyRef; return (A) this;
    }

    public java.lang.Boolean hasConfigMapKeyRef() {
        return this.configMapKeyRef != null;
    }

    public A withNewConfigMapKeyRef(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
        return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name, optional));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExternalConfigurationReferenceFluentImpl that = (ExternalConfigurationReferenceFluentImpl) o;
        if (configMapKeyRef != null ? !configMapKeyRef.equals(that.configMapKeyRef) :that.configMapKeyRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(configMapKeyRef,  super.hashCode());
    }

}
