package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public class ExternalLoggingBuilder extends io.strimzi.api.kafka.model.ExternalLoggingFluentImpl<io.strimzi.api.kafka.model.ExternalLoggingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.ExternalLogging,io.strimzi.api.kafka.model.ExternalLoggingBuilder> {

    io.strimzi.api.kafka.model.ExternalLoggingFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExternalLoggingBuilder() {
        this(true);
    }

    public ExternalLoggingBuilder(java.lang.Boolean validationEnabled) {
        this(new ExternalLogging(), validationEnabled);
    }

    public ExternalLoggingBuilder(io.strimzi.api.kafka.model.ExternalLoggingFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalLoggingBuilder(io.strimzi.api.kafka.model.ExternalLoggingFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExternalLogging(), validationEnabled);
    }

    public ExternalLoggingBuilder(io.strimzi.api.kafka.model.ExternalLoggingFluent<?> fluent,io.strimzi.api.kafka.model.ExternalLogging instance) {
        this(fluent, instance, true);
    }

    public ExternalLoggingBuilder(io.strimzi.api.kafka.model.ExternalLoggingFluent<?> fluent,io.strimzi.api.kafka.model.ExternalLogging instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withValueFrom(instance.getValueFrom());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalLoggingBuilder(io.strimzi.api.kafka.model.ExternalLogging instance) {
        this(instance,true);
    }

    public ExternalLoggingBuilder(io.strimzi.api.kafka.model.ExternalLogging instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withValueFrom(instance.getValueFrom());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.ExternalLogging build() {
        ExternalLogging buildable = new ExternalLogging();
        buildable.setValueFrom(fluent.getValueFrom());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalLoggingBuilder that = (ExternalLoggingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
