package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public class GenericSecretSourceBuilder extends io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.GenericSecretSource,io.strimzi.api.kafka.model.GenericSecretSourceBuilder> {

    io.strimzi.api.kafka.model.GenericSecretSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GenericSecretSourceBuilder() {
        this(true);
    }

    public GenericSecretSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new GenericSecretSource(), validationEnabled);
    }

    public GenericSecretSourceBuilder(io.strimzi.api.kafka.model.GenericSecretSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public GenericSecretSourceBuilder(io.strimzi.api.kafka.model.GenericSecretSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GenericSecretSource(), validationEnabled);
    }

    public GenericSecretSourceBuilder(io.strimzi.api.kafka.model.GenericSecretSourceFluent<?> fluent,io.strimzi.api.kafka.model.GenericSecretSource instance) {
        this(fluent, instance, true);
    }

    public GenericSecretSourceBuilder(io.strimzi.api.kafka.model.GenericSecretSourceFluent<?> fluent,io.strimzi.api.kafka.model.GenericSecretSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSecretName(instance.getSecretName());
        
        fluent.withKey(instance.getKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public GenericSecretSourceBuilder(io.strimzi.api.kafka.model.GenericSecretSource instance) {
        this(instance,true);
    }

    public GenericSecretSourceBuilder(io.strimzi.api.kafka.model.GenericSecretSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSecretName(instance.getSecretName());
        
        this.withKey(instance.getKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.GenericSecretSource build() {
        GenericSecretSource buildable = new GenericSecretSource();
        buildable.setSecretName(fluent.getSecretName());
        buildable.setKey(fluent.getKey());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GenericSecretSourceBuilder that = (GenericSecretSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
