package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Logging config is given inline with the resource
   */
  public class InlineLoggingBuilder extends io.strimzi.api.kafka.model.InlineLoggingFluentImpl<io.strimzi.api.kafka.model.InlineLoggingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.InlineLogging,io.strimzi.api.kafka.model.InlineLoggingBuilder> {

    io.strimzi.api.kafka.model.InlineLoggingFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public InlineLoggingBuilder() {
        this(true);
    }

    public InlineLoggingBuilder(java.lang.Boolean validationEnabled) {
        this(new InlineLogging(), validationEnabled);
    }

    public InlineLoggingBuilder(io.strimzi.api.kafka.model.InlineLoggingFluent<?> fluent) {
        this(fluent, true);
    }

    public InlineLoggingBuilder(io.strimzi.api.kafka.model.InlineLoggingFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new InlineLogging(), validationEnabled);
    }

    public InlineLoggingBuilder(io.strimzi.api.kafka.model.InlineLoggingFluent<?> fluent,io.strimzi.api.kafka.model.InlineLogging instance) {
        this(fluent, instance, true);
    }

    public InlineLoggingBuilder(io.strimzi.api.kafka.model.InlineLoggingFluent<?> fluent,io.strimzi.api.kafka.model.InlineLogging instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLoggers(instance.getLoggers());
        
        this.validationEnabled = validationEnabled; 
    }

    public InlineLoggingBuilder(io.strimzi.api.kafka.model.InlineLogging instance) {
        this(instance,true);
    }

    public InlineLoggingBuilder(io.strimzi.api.kafka.model.InlineLogging instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLoggers(instance.getLoggers());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.InlineLogging build() {
        InlineLogging buildable = new InlineLogging();
        buildable.setLoggers(fluent.getLoggers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InlineLoggingBuilder that = (InlineLoggingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
