package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for options to be passed into setting up the JmxTrans.
   */
  public class JmxTransSpecBuilder extends io.strimzi.api.kafka.model.JmxTransSpecFluentImpl<io.strimzi.api.kafka.model.JmxTransSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.JmxTransSpec,io.strimzi.api.kafka.model.JmxTransSpecBuilder> {

    io.strimzi.api.kafka.model.JmxTransSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public JmxTransSpecBuilder() {
        this(true);
    }

    public JmxTransSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new JmxTransSpec(), validationEnabled);
    }

    public JmxTransSpecBuilder(io.strimzi.api.kafka.model.JmxTransSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public JmxTransSpecBuilder(io.strimzi.api.kafka.model.JmxTransSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new JmxTransSpec(), validationEnabled);
    }

    public JmxTransSpecBuilder(io.strimzi.api.kafka.model.JmxTransSpecFluent<?> fluent,io.strimzi.api.kafka.model.JmxTransSpec instance) {
        this(fluent, instance, true);
    }

    public JmxTransSpecBuilder(io.strimzi.api.kafka.model.JmxTransSpecFluent<?> fluent,io.strimzi.api.kafka.model.JmxTransSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImage(instance.getImage());
        
        fluent.withLogLevel(instance.getLogLevel());
        
        fluent.withOutputDefinitions(instance.getOutputDefinitions());
        
        fluent.withKafkaQueries(instance.getKafkaQueries());
        
        fluent.withResources(instance.getResources());
        
        fluent.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public JmxTransSpecBuilder(io.strimzi.api.kafka.model.JmxTransSpec instance) {
        this(instance,true);
    }

    public JmxTransSpecBuilder(io.strimzi.api.kafka.model.JmxTransSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withImage(instance.getImage());
        
        this.withLogLevel(instance.getLogLevel());
        
        this.withOutputDefinitions(instance.getOutputDefinitions());
        
        this.withKafkaQueries(instance.getKafkaQueries());
        
        this.withResources(instance.getResources());
        
        this.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.JmxTransSpec build() {
        JmxTransSpec buildable = new JmxTransSpec();
        buildable.setImage(fluent.getImage());
        buildable.setLogLevel(fluent.getLogLevel());
        buildable.setOutputDefinitions(fluent.getOutputDefinitions());
        buildable.setKafkaQueries(fluent.getKafkaQueries());
        buildable.setResources(fluent.getResources());
        buildable.setTemplate(fluent.getTemplate());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JmxTransSpecBuilder that = (JmxTransSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
