package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransTemplateFluentImpl;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplate;
import io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluentImpl;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateFluentImpl;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.JmxTransTemplate;

  
  /**
   * Representation for options to be passed into setting up the JmxTrans.
   */
  public class JmxTransSpecFluentImpl<A extends io.strimzi.api.kafka.model.JmxTransSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.JmxTransSpecFluent<A> {

    private java.lang.String image;
    private java.lang.String logLevel;
    private java.util.List<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder> outputDefinitions;
    private java.util.List<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder> kafkaQueries;
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    private io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder template;

    public JmxTransSpecFluentImpl() {
    }

    public JmxTransSpecFluentImpl(io.strimzi.api.kafka.model.JmxTransSpec instance) {
        this.withImage(instance.getImage());
        
        this.withLogLevel(instance.getLogLevel());
        
        this.withOutputDefinitions(instance.getOutputDefinitions());
        
        this.withKafkaQueries(instance.getKafkaQueries());
        
        this.withResources(instance.getResources());
        
        this.withTemplate(instance.getTemplate());
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original) {
        return (A)withImage(new String(original));
    }

    public java.lang.String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(java.lang.String logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public java.lang.Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLogLevel instead.
     */
        public A withNewLogLevel(java.lang.String original) {
        return (A)withLogLevel(new String(original));
    }

    public A addToOutputDefinitions(int index,io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item) {
        if (this.outputDefinitions == null) {this.outputDefinitions = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder>();}
        io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").add(index >= 0 ? index : _visitables.get("outputDefinitions").size(), builder);this.outputDefinitions.add(index >= 0 ? index : outputDefinitions.size(), builder); return (A)this;
    }

    public A setToOutputDefinitions(int index,io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item) {
        if (this.outputDefinitions == null) {this.outputDefinitions = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder>();}
        io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder(item);
        if (index < 0 || index >= _visitables.get("outputDefinitions").size()) { _visitables.get("outputDefinitions").add(builder); } else { _visitables.get("outputDefinitions").set(index, builder);}
        if (index < 0 || index >= outputDefinitions.size()) { outputDefinitions.add(builder); } else { outputDefinitions.set(index, builder);}
         return (A)this;
    }

    public A addToOutputDefinitions(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate... items) {
        if (this.outputDefinitions == null) {this.outputDefinitions = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder>();}
        for (io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item : items) {io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").add(builder);this.outputDefinitions.add(builder);} return (A)this;
    }

    public A addAllToOutputDefinitions(java.util.Collection<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate> items) {
        if (this.outputDefinitions == null) {this.outputDefinitions = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder>();}
        for (io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item : items) {io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").add(builder);this.outputDefinitions.add(builder);} return (A)this;
    }

    public A removeFromOutputDefinitions(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate... items) {
        for (io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item : items) {io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").remove(builder);if (this.outputDefinitions != null) {this.outputDefinitions.remove(builder);}} return (A)this;
    }

    public A removeAllFromOutputDefinitions(java.util.Collection<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate> items) {
        for (io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item : items) {io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").remove(builder);if (this.outputDefinitions != null) {this.outputDefinitions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOutputDefinitions(java.util.function.Predicate<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder> predicate) {
        if (outputDefinitions == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder> each = outputDefinitions.iterator();
        final List visitables = _visitables.get("outputDefinitions");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildOutputDefinitions instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate> getOutputDefinitions() {
        return build(outputDefinitions);
    }

    public java.util.List<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate> buildOutputDefinitions() {
        return build(outputDefinitions);
    }

    public io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate buildOutputDefinition(int index) {
        return this.outputDefinitions.get(index).build();
    }

    public io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate buildFirstOutputDefinition() {
        return this.outputDefinitions.get(0).build();
    }

    public io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate buildLastOutputDefinition() {
        return this.outputDefinitions.get(outputDefinitions.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate buildMatchingOutputDefinition(java.util.function.Predicate<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder> predicate) {
        for (io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder item: outputDefinitions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingOutputDefinition(java.util.function.Predicate<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder> predicate) {
        for (io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder item: outputDefinitions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withOutputDefinitions(java.util.List<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate> outputDefinitions) {
        if (this.outputDefinitions != null) { _visitables.get("outputDefinitions").removeAll(this.outputDefinitions);}
        if (outputDefinitions != null) {this.outputDefinitions = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder>(); for (io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item : outputDefinitions){this.addToOutputDefinitions(item);}} else { this.outputDefinitions = null;} return (A) this;
    }

    public A withOutputDefinitions(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate... outputDefinitions) {
        if (this.outputDefinitions != null) {this.outputDefinitions.clear();}
        if (outputDefinitions != null) {for (io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item :outputDefinitions){ this.addToOutputDefinitions(item);}} return (A) this;
    }

    public java.lang.Boolean hasOutputDefinitions() {
        return outputDefinitions != null && !outputDefinitions.isEmpty();
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.OutputDefinitionsNested<A> addNewOutputDefinition() {
        return new io.strimzi.api.kafka.model.JmxTransSpecFluentImpl.OutputDefinitionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.OutputDefinitionsNested<A> addNewOutputDefinitionLike(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item) {
        return new io.strimzi.api.kafka.model.JmxTransSpecFluentImpl.OutputDefinitionsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.OutputDefinitionsNested<A> setNewOutputDefinitionLike(int index,io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item) {
        return new io.strimzi.api.kafka.model.JmxTransSpecFluentImpl.OutputDefinitionsNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.OutputDefinitionsNested<A> editOutputDefinition(int index) {
        if (outputDefinitions.size() <= index) throw new RuntimeException("Can't edit outputDefinitions. Index exceeds size.");
        return setNewOutputDefinitionLike(index, buildOutputDefinition(index));
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.OutputDefinitionsNested<A> editFirstOutputDefinition() {
        if (outputDefinitions.size() == 0) throw new RuntimeException("Can't edit first outputDefinitions. The list is empty.");
        return setNewOutputDefinitionLike(0, buildOutputDefinition(0));
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.OutputDefinitionsNested<A> editLastOutputDefinition() {
        int index = outputDefinitions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last outputDefinitions. The list is empty.");
        return setNewOutputDefinitionLike(index, buildOutputDefinition(index));
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.OutputDefinitionsNested<A> editMatchingOutputDefinition(java.util.function.Predicate<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder> predicate) {
        int index = -1;
        for (int i=0;i<outputDefinitions.size();i++) { 
        if (predicate.test(outputDefinitions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching outputDefinitions. No match found.");
        return setNewOutputDefinitionLike(index, buildOutputDefinition(index));
    }

    public A addToKafkaQueries(int index,io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item) {
        if (this.kafkaQueries == null) {this.kafkaQueries = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder>();}
        io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").add(index >= 0 ? index : _visitables.get("kafkaQueries").size(), builder);this.kafkaQueries.add(index >= 0 ? index : kafkaQueries.size(), builder); return (A)this;
    }

    public A setToKafkaQueries(int index,io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item) {
        if (this.kafkaQueries == null) {this.kafkaQueries = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder>();}
        io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder(item);
        if (index < 0 || index >= _visitables.get("kafkaQueries").size()) { _visitables.get("kafkaQueries").add(builder); } else { _visitables.get("kafkaQueries").set(index, builder);}
        if (index < 0 || index >= kafkaQueries.size()) { kafkaQueries.add(builder); } else { kafkaQueries.set(index, builder);}
         return (A)this;
    }

    public A addToKafkaQueries(io.strimzi.api.kafka.model.template.JmxTransQueryTemplate... items) {
        if (this.kafkaQueries == null) {this.kafkaQueries = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder>();}
        for (io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item : items) {io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").add(builder);this.kafkaQueries.add(builder);} return (A)this;
    }

    public A addAllToKafkaQueries(java.util.Collection<io.strimzi.api.kafka.model.template.JmxTransQueryTemplate> items) {
        if (this.kafkaQueries == null) {this.kafkaQueries = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder>();}
        for (io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item : items) {io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").add(builder);this.kafkaQueries.add(builder);} return (A)this;
    }

    public A removeFromKafkaQueries(io.strimzi.api.kafka.model.template.JmxTransQueryTemplate... items) {
        for (io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item : items) {io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").remove(builder);if (this.kafkaQueries != null) {this.kafkaQueries.remove(builder);}} return (A)this;
    }

    public A removeAllFromKafkaQueries(java.util.Collection<io.strimzi.api.kafka.model.template.JmxTransQueryTemplate> items) {
        for (io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item : items) {io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder builder = new io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").remove(builder);if (this.kafkaQueries != null) {this.kafkaQueries.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromKafkaQueries(java.util.function.Predicate<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder> predicate) {
        if (kafkaQueries == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder> each = kafkaQueries.iterator();
        final List visitables = _visitables.get("kafkaQueries");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKafkaQueries instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.template.JmxTransQueryTemplate> getKafkaQueries() {
        return build(kafkaQueries);
    }

    public java.util.List<io.strimzi.api.kafka.model.template.JmxTransQueryTemplate> buildKafkaQueries() {
        return build(kafkaQueries);
    }

    public io.strimzi.api.kafka.model.template.JmxTransQueryTemplate buildKafkaQuery(int index) {
        return this.kafkaQueries.get(index).build();
    }

    public io.strimzi.api.kafka.model.template.JmxTransQueryTemplate buildFirstKafkaQuery() {
        return this.kafkaQueries.get(0).build();
    }

    public io.strimzi.api.kafka.model.template.JmxTransQueryTemplate buildLastKafkaQuery() {
        return this.kafkaQueries.get(kafkaQueries.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.template.JmxTransQueryTemplate buildMatchingKafkaQuery(java.util.function.Predicate<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder> predicate) {
        for (io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder item: kafkaQueries) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingKafkaQuery(java.util.function.Predicate<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder> predicate) {
        for (io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder item: kafkaQueries) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withKafkaQueries(java.util.List<io.strimzi.api.kafka.model.template.JmxTransQueryTemplate> kafkaQueries) {
        if (this.kafkaQueries != null) { _visitables.get("kafkaQueries").removeAll(this.kafkaQueries);}
        if (kafkaQueries != null) {this.kafkaQueries = new java.util.ArrayList<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder>(); for (io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item : kafkaQueries){this.addToKafkaQueries(item);}} else { this.kafkaQueries = null;} return (A) this;
    }

    public A withKafkaQueries(io.strimzi.api.kafka.model.template.JmxTransQueryTemplate... kafkaQueries) {
        if (this.kafkaQueries != null) {this.kafkaQueries.clear();}
        if (kafkaQueries != null) {for (io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item :kafkaQueries){ this.addToKafkaQueries(item);}} return (A) this;
    }

    public java.lang.Boolean hasKafkaQueries() {
        return kafkaQueries != null && !kafkaQueries.isEmpty();
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.KafkaQueriesNested<A> addNewKafkaQuery() {
        return new io.strimzi.api.kafka.model.JmxTransSpecFluentImpl.KafkaQueriesNestedImpl();
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.KafkaQueriesNested<A> addNewKafkaQueryLike(io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item) {
        return new io.strimzi.api.kafka.model.JmxTransSpecFluentImpl.KafkaQueriesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.KafkaQueriesNested<A> setNewKafkaQueryLike(int index,io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item) {
        return new io.strimzi.api.kafka.model.JmxTransSpecFluentImpl.KafkaQueriesNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.KafkaQueriesNested<A> editKafkaQuery(int index) {
        if (kafkaQueries.size() <= index) throw new RuntimeException("Can't edit kafkaQueries. Index exceeds size.");
        return setNewKafkaQueryLike(index, buildKafkaQuery(index));
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.KafkaQueriesNested<A> editFirstKafkaQuery() {
        if (kafkaQueries.size() == 0) throw new RuntimeException("Can't edit first kafkaQueries. The list is empty.");
        return setNewKafkaQueryLike(0, buildKafkaQuery(0));
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.KafkaQueriesNested<A> editLastKafkaQuery() {
        int index = kafkaQueries.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last kafkaQueries. The list is empty.");
        return setNewKafkaQueryLike(index, buildKafkaQuery(index));
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.KafkaQueriesNested<A> editMatchingKafkaQuery(java.util.function.Predicate<io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder> predicate) {
        int index = -1;
        for (int i=0;i<kafkaQueries.size();i++) { 
        if (predicate.test(kafkaQueries.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching kafkaQueries. No match found.");
        return setNewKafkaQueryLike(index, buildKafkaQuery(index));
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.JmxTransTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.JmxTransTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.JmxTransTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.JmxTransSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.JmxTransTemplate item) {
        return new io.strimzi.api.kafka.model.JmxTransSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.JmxTransSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.JmxTransTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JmxTransSpecFluentImpl that = (JmxTransSpecFluentImpl) o;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (outputDefinitions != null ? !outputDefinitions.equals(that.outputDefinitions) :that.outputDefinitions != null) return false;
        if (kafkaQueries != null ? !kafkaQueries.equals(that.kafkaQueries) :that.kafkaQueries != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(image,  logLevel,  outputDefinitions,  kafkaQueries,  resources,  template,  super.hashCode());
    }

      
  /**
   * Representation for options to define where and how information will be pushed to remote sources of information
   */
  public class OutputDefinitionsNestedImpl<N> extends io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluentImpl<io.strimzi.api.kafka.model.JmxTransSpecFluent.OutputDefinitionsNested<N>> implements io.strimzi.api.kafka.model.JmxTransSpecFluent.OutputDefinitionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder builder;
        private final int index;

            OutputDefinitionsNestedImpl(int index,io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder(this, item);
                        
            }

            OutputDefinitionsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) JmxTransSpecFluentImpl.this.setToOutputDefinitions(index,builder.build());
            }

            public N endOutputDefinition() {
                return and();
            }
    }


    public class KafkaQueriesNestedImpl<N> extends io.strimzi.api.kafka.model.template.JmxTransQueryTemplateFluentImpl<io.strimzi.api.kafka.model.JmxTransSpecFluent.KafkaQueriesNested<N>> implements io.strimzi.api.kafka.model.JmxTransSpecFluent.KafkaQueriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder builder;
        private final int index;

            KafkaQueriesNestedImpl(int index,io.strimzi.api.kafka.model.template.JmxTransQueryTemplate item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder(this, item);
                        
            }

            KafkaQueriesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) JmxTransSpecFluentImpl.this.setToKafkaQueries(index,builder.build());
            }

            public N endKafkaQuery() {
                return and();
            }
    }


      
  /**
   * Representation of a template for JmxTrans resources.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.JmxTransTemplateFluentImpl<io.strimzi.api.kafka.model.JmxTransSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.JmxTransSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.JmxTransTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) JmxTransSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


}
