package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for options to be passed to a JVM.
   */
  public class JvmOptionsBuilder extends io.strimzi.api.kafka.model.JvmOptionsFluentImpl<io.strimzi.api.kafka.model.JvmOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.JvmOptions,io.strimzi.api.kafka.model.JvmOptionsBuilder> {

    io.strimzi.api.kafka.model.JvmOptionsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public JvmOptionsBuilder() {
        this(true);
    }

    public JvmOptionsBuilder(java.lang.Boolean validationEnabled) {
        this(new JvmOptions(), validationEnabled);
    }

    public JvmOptionsBuilder(io.strimzi.api.kafka.model.JvmOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public JvmOptionsBuilder(io.strimzi.api.kafka.model.JvmOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new JvmOptions(), validationEnabled);
    }

    public JvmOptionsBuilder(io.strimzi.api.kafka.model.JvmOptionsFluent<?> fluent,io.strimzi.api.kafka.model.JvmOptions instance) {
        this(fluent, instance, true);
    }

    public JvmOptionsBuilder(io.strimzi.api.kafka.model.JvmOptionsFluent<?> fluent,io.strimzi.api.kafka.model.JvmOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withXmx(instance.getXmx());
        
        fluent.withXms(instance.getXms());
        
        fluent.withGcLoggingEnabled(instance.isGcLoggingEnabled());
        
        fluent.withJavaSystemProperties(instance.getJavaSystemProperties());
        
        fluent.withXx(instance.getXx());
        
        this.validationEnabled = validationEnabled; 
    }

    public JvmOptionsBuilder(io.strimzi.api.kafka.model.JvmOptions instance) {
        this(instance,true);
    }

    public JvmOptionsBuilder(io.strimzi.api.kafka.model.JvmOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withXmx(instance.getXmx());
        
        this.withXms(instance.getXms());
        
        this.withGcLoggingEnabled(instance.isGcLoggingEnabled());
        
        this.withJavaSystemProperties(instance.getJavaSystemProperties());
        
        this.withXx(instance.getXx());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.JvmOptions build() {
        JvmOptions buildable = new JvmOptions();
        buildable.setXmx(fluent.getXmx());
        buildable.setXms(fluent.getXms());
        buildable.setGcLoggingEnabled(fluent.isGcLoggingEnabled());
        buildable.setJavaSystemProperties(fluent.getJavaSystemProperties());
        buildable.setXx(fluent.getXx());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JvmOptionsBuilder that = (JvmOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
