package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Representation for options to be passed to a JVM.
   */
  public class JvmOptionsFluentImpl<A extends io.strimzi.api.kafka.model.JvmOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.JvmOptionsFluent<A> {

    private java.lang.String xmx;
    private java.lang.String xms;
    private boolean gcLoggingEnabled;
    private java.util.List<io.strimzi.api.kafka.model.SystemPropertyBuilder> javaSystemProperties;
    private java.util.Map<java.lang.String,java.lang.String> xx;

    public JvmOptionsFluentImpl() {
    }

    public JvmOptionsFluentImpl(io.strimzi.api.kafka.model.JvmOptions instance) {
        this.withXmx(instance.getXmx());
        
        this.withXms(instance.getXms());
        
        this.withGcLoggingEnabled(instance.isGcLoggingEnabled());
        
        this.withJavaSystemProperties(instance.getJavaSystemProperties());
        
        this.withXx(instance.getXx());
    }

    public java.lang.String getXmx() {
        return this.xmx;
    }

    public A withXmx(java.lang.String xmx) {
        this.xmx=xmx; return (A) this;
    }

    public java.lang.Boolean hasXmx() {
        return this.xmx != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withXmx instead.
     */
        public A withNewXmx(java.lang.String original) {
        return (A)withXmx(new String(original));
    }

    public java.lang.String getXms() {
        return this.xms;
    }

    public A withXms(java.lang.String xms) {
        this.xms=xms; return (A) this;
    }

    public java.lang.Boolean hasXms() {
        return this.xms != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withXms instead.
     */
        public A withNewXms(java.lang.String original) {
        return (A)withXms(new String(original));
    }

    public boolean isGcLoggingEnabled() {
        return this.gcLoggingEnabled;
    }

    public A withGcLoggingEnabled(boolean gcLoggingEnabled) {
        this.gcLoggingEnabled=gcLoggingEnabled; return (A) this;
    }

    public java.lang.Boolean hasGcLoggingEnabled() {
        return true;
    }

    public A addToJavaSystemProperties(int index,io.strimzi.api.kafka.model.SystemProperty item) {
        if (this.javaSystemProperties == null) {this.javaSystemProperties = new java.util.ArrayList<io.strimzi.api.kafka.model.SystemPropertyBuilder>();}
        io.strimzi.api.kafka.model.SystemPropertyBuilder builder = new io.strimzi.api.kafka.model.SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").add(index >= 0 ? index : _visitables.get("javaSystemProperties").size(), builder);this.javaSystemProperties.add(index >= 0 ? index : javaSystemProperties.size(), builder); return (A)this;
    }

    public A setToJavaSystemProperties(int index,io.strimzi.api.kafka.model.SystemProperty item) {
        if (this.javaSystemProperties == null) {this.javaSystemProperties = new java.util.ArrayList<io.strimzi.api.kafka.model.SystemPropertyBuilder>();}
        io.strimzi.api.kafka.model.SystemPropertyBuilder builder = new io.strimzi.api.kafka.model.SystemPropertyBuilder(item);
        if (index < 0 || index >= _visitables.get("javaSystemProperties").size()) { _visitables.get("javaSystemProperties").add(builder); } else { _visitables.get("javaSystemProperties").set(index, builder);}
        if (index < 0 || index >= javaSystemProperties.size()) { javaSystemProperties.add(builder); } else { javaSystemProperties.set(index, builder);}
         return (A)this;
    }

    public A addToJavaSystemProperties(io.strimzi.api.kafka.model.SystemProperty... items) {
        if (this.javaSystemProperties == null) {this.javaSystemProperties = new java.util.ArrayList<io.strimzi.api.kafka.model.SystemPropertyBuilder>();}
        for (io.strimzi.api.kafka.model.SystemProperty item : items) {io.strimzi.api.kafka.model.SystemPropertyBuilder builder = new io.strimzi.api.kafka.model.SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").add(builder);this.javaSystemProperties.add(builder);} return (A)this;
    }

    public A addAllToJavaSystemProperties(java.util.Collection<io.strimzi.api.kafka.model.SystemProperty> items) {
        if (this.javaSystemProperties == null) {this.javaSystemProperties = new java.util.ArrayList<io.strimzi.api.kafka.model.SystemPropertyBuilder>();}
        for (io.strimzi.api.kafka.model.SystemProperty item : items) {io.strimzi.api.kafka.model.SystemPropertyBuilder builder = new io.strimzi.api.kafka.model.SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").add(builder);this.javaSystemProperties.add(builder);} return (A)this;
    }

    public A removeFromJavaSystemProperties(io.strimzi.api.kafka.model.SystemProperty... items) {
        for (io.strimzi.api.kafka.model.SystemProperty item : items) {io.strimzi.api.kafka.model.SystemPropertyBuilder builder = new io.strimzi.api.kafka.model.SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").remove(builder);if (this.javaSystemProperties != null) {this.javaSystemProperties.remove(builder);}} return (A)this;
    }

    public A removeAllFromJavaSystemProperties(java.util.Collection<io.strimzi.api.kafka.model.SystemProperty> items) {
        for (io.strimzi.api.kafka.model.SystemProperty item : items) {io.strimzi.api.kafka.model.SystemPropertyBuilder builder = new io.strimzi.api.kafka.model.SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").remove(builder);if (this.javaSystemProperties != null) {this.javaSystemProperties.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromJavaSystemProperties(java.util.function.Predicate<io.strimzi.api.kafka.model.SystemPropertyBuilder> predicate) {
        if (javaSystemProperties == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.SystemPropertyBuilder> each = javaSystemProperties.iterator();
        final List visitables = _visitables.get("javaSystemProperties");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.SystemPropertyBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJavaSystemProperties instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.SystemProperty> getJavaSystemProperties() {
        return build(javaSystemProperties);
    }

    public java.util.List<io.strimzi.api.kafka.model.SystemProperty> buildJavaSystemProperties() {
        return build(javaSystemProperties);
    }

    public io.strimzi.api.kafka.model.SystemProperty buildJavaSystemProperty(int index) {
        return this.javaSystemProperties.get(index).build();
    }

    public io.strimzi.api.kafka.model.SystemProperty buildFirstJavaSystemProperty() {
        return this.javaSystemProperties.get(0).build();
    }

    public io.strimzi.api.kafka.model.SystemProperty buildLastJavaSystemProperty() {
        return this.javaSystemProperties.get(javaSystemProperties.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.SystemProperty buildMatchingJavaSystemProperty(java.util.function.Predicate<io.strimzi.api.kafka.model.SystemPropertyBuilder> predicate) {
        for (io.strimzi.api.kafka.model.SystemPropertyBuilder item: javaSystemProperties) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingJavaSystemProperty(java.util.function.Predicate<io.strimzi.api.kafka.model.SystemPropertyBuilder> predicate) {
        for (io.strimzi.api.kafka.model.SystemPropertyBuilder item: javaSystemProperties) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withJavaSystemProperties(java.util.List<io.strimzi.api.kafka.model.SystemProperty> javaSystemProperties) {
        if (this.javaSystemProperties != null) { _visitables.get("javaSystemProperties").removeAll(this.javaSystemProperties);}
        if (javaSystemProperties != null) {this.javaSystemProperties = new java.util.ArrayList<io.strimzi.api.kafka.model.SystemPropertyBuilder>(); for (io.strimzi.api.kafka.model.SystemProperty item : javaSystemProperties){this.addToJavaSystemProperties(item);}} else { this.javaSystemProperties = null;} return (A) this;
    }

    public A withJavaSystemProperties(io.strimzi.api.kafka.model.SystemProperty... javaSystemProperties) {
        if (this.javaSystemProperties != null) {this.javaSystemProperties.clear();}
        if (javaSystemProperties != null) {for (io.strimzi.api.kafka.model.SystemProperty item :javaSystemProperties){ this.addToJavaSystemProperties(item);}} return (A) this;
    }

    public java.lang.Boolean hasJavaSystemProperties() {
        return javaSystemProperties != null && !javaSystemProperties.isEmpty();
    }

    public io.strimzi.api.kafka.model.JvmOptionsFluent.JavaSystemPropertiesNested<A> addNewJavaSystemProperty() {
        return new io.strimzi.api.kafka.model.JvmOptionsFluentImpl.JavaSystemPropertiesNestedImpl();
    }

    public io.strimzi.api.kafka.model.JvmOptionsFluent.JavaSystemPropertiesNested<A> addNewJavaSystemPropertyLike(io.strimzi.api.kafka.model.SystemProperty item) {
        return new io.strimzi.api.kafka.model.JvmOptionsFluentImpl.JavaSystemPropertiesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.JvmOptionsFluent.JavaSystemPropertiesNested<A> setNewJavaSystemPropertyLike(int index,io.strimzi.api.kafka.model.SystemProperty item) {
        return new io.strimzi.api.kafka.model.JvmOptionsFluentImpl.JavaSystemPropertiesNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.JvmOptionsFluent.JavaSystemPropertiesNested<A> editJavaSystemProperty(int index) {
        if (javaSystemProperties.size() <= index) throw new RuntimeException("Can't edit javaSystemProperties. Index exceeds size.");
        return setNewJavaSystemPropertyLike(index, buildJavaSystemProperty(index));
    }

    public io.strimzi.api.kafka.model.JvmOptionsFluent.JavaSystemPropertiesNested<A> editFirstJavaSystemProperty() {
        if (javaSystemProperties.size() == 0) throw new RuntimeException("Can't edit first javaSystemProperties. The list is empty.");
        return setNewJavaSystemPropertyLike(0, buildJavaSystemProperty(0));
    }

    public io.strimzi.api.kafka.model.JvmOptionsFluent.JavaSystemPropertiesNested<A> editLastJavaSystemProperty() {
        int index = javaSystemProperties.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last javaSystemProperties. The list is empty.");
        return setNewJavaSystemPropertyLike(index, buildJavaSystemProperty(index));
    }

    public io.strimzi.api.kafka.model.JvmOptionsFluent.JavaSystemPropertiesNested<A> editMatchingJavaSystemProperty(java.util.function.Predicate<io.strimzi.api.kafka.model.SystemPropertyBuilder> predicate) {
        int index = -1;
        for (int i=0;i<javaSystemProperties.size();i++) { 
        if (predicate.test(javaSystemProperties.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching javaSystemProperties. No match found.");
        return setNewJavaSystemPropertyLike(index, buildJavaSystemProperty(index));
    }

    public A addToXx(java.lang.String key,java.lang.String value) {
        if(this.xx == null && key != null && value != null) { this.xx = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.xx.put(key, value);} return (A)this;
    }

    public A addToXx(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.xx == null && map != null) { this.xx = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.xx.putAll(map);} return (A)this;
    }

    public A removeFromXx(java.lang.String key) {
        if(this.xx == null) { return (A) this; }
        if(key != null && this.xx != null) {this.xx.remove(key);} return (A)this;
    }

    public A removeFromXx(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.xx == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.xx != null){this.xx.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getXx() {
        return this.xx;
    }

    public <K,V>A withXx(java.util.Map<java.lang.String,java.lang.String> xx) {
        if (xx == null) { this.xx =  null;} else {this.xx = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(xx);} return (A) this;
    }

    public java.lang.Boolean hasXx() {
        return this.xx != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JvmOptionsFluentImpl that = (JvmOptionsFluentImpl) o;
        if (xmx != null ? !xmx.equals(that.xmx) :that.xmx != null) return false;
        if (xms != null ? !xms.equals(that.xms) :that.xms != null) return false;
        if (gcLoggingEnabled != that.gcLoggingEnabled) return false;
        if (javaSystemProperties != null ? !javaSystemProperties.equals(that.javaSystemProperties) :that.javaSystemProperties != null) return false;
        if (xx != null ? !xx.equals(that.xx) :that.xx != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(xmx,  xms,  gcLoggingEnabled,  javaSystemProperties,  xx,  super.hashCode());
    }

      
  /**
   * Representation for SystemProperty variables for Strimzi containers.
   */
  public class JavaSystemPropertiesNestedImpl<N> extends io.strimzi.api.kafka.model.SystemPropertyFluentImpl<io.strimzi.api.kafka.model.JvmOptionsFluent.JavaSystemPropertiesNested<N>> implements io.strimzi.api.kafka.model.JvmOptionsFluent.JavaSystemPropertiesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.SystemPropertyBuilder builder;
        private final int index;

            JavaSystemPropertiesNestedImpl(int index,io.strimzi.api.kafka.model.SystemProperty item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.SystemPropertyBuilder(this, item);
                        
            }

            JavaSystemPropertiesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.SystemPropertyBuilder(this);
                        
            }

            public N and() {
                return (N) JvmOptionsFluentImpl.this.setToJavaSystemProperties(index,builder.build());
            }

            public N endJavaSystemProperty() {
                return and();
            }
    }


}
