package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures the broker for custom authorization module
   */
  public class KafkaAuthorizationCustomBuilder extends io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluentImpl<io.strimzi.api.kafka.model.KafkaAuthorizationCustomBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaAuthorizationCustom,io.strimzi.api.kafka.model.KafkaAuthorizationCustomBuilder> {

    io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaAuthorizationCustomBuilder() {
        this(true);
    }

    public KafkaAuthorizationCustomBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaAuthorizationCustom(), validationEnabled);
    }

    public KafkaAuthorizationCustomBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaAuthorizationCustomBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaAuthorizationCustom(), validationEnabled);
    }

    public KafkaAuthorizationCustomBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent<?> fluent,io.strimzi.api.kafka.model.KafkaAuthorizationCustom instance) {
        this(fluent, instance, true);
    }

    public KafkaAuthorizationCustomBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent<?> fluent,io.strimzi.api.kafka.model.KafkaAuthorizationCustom instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuthorizerClass(instance.getAuthorizerClass());
        
        fluent.withSuperUsers(instance.getSuperUsers());
        
        fluent.withSupportsAdminApi(instance.isSupportsAdminApi());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaAuthorizationCustomBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationCustom instance) {
        this(instance,true);
    }

    public KafkaAuthorizationCustomBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationCustom instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuthorizerClass(instance.getAuthorizerClass());
        
        this.withSuperUsers(instance.getSuperUsers());
        
        this.withSupportsAdminApi(instance.isSupportsAdminApi());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationCustom build() {
        KafkaAuthorizationCustom buildable = new KafkaAuthorizationCustom();
        buildable.setAuthorizerClass(fluent.getAuthorizerClass());
        buildable.setSuperUsers(fluent.getSuperUsers());
        buildable.setSupportsAdminApi(fluent.isSupportsAdminApi());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaAuthorizationCustomBuilder that = (KafkaAuthorizationCustomBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
