package io.strimzi.api.kafka.model;

import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.function.Predicate;

  
  /**
   * Configures the broker for custom authorization module
   */
  public class KafkaAuthorizationCustomFluentImpl<A extends io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent<A> {

    private java.lang.String authorizerClass;
    private java.util.List<java.lang.String> superUsers;
    private boolean supportsAdminApi;

    public KafkaAuthorizationCustomFluentImpl() {
    }

    public KafkaAuthorizationCustomFluentImpl(io.strimzi.api.kafka.model.KafkaAuthorizationCustom instance) {
        this.withAuthorizerClass(instance.getAuthorizerClass());
        
        this.withSuperUsers(instance.getSuperUsers());
        
        this.withSupportsAdminApi(instance.isSupportsAdminApi());
    }

    public java.lang.String getAuthorizerClass() {
        return this.authorizerClass;
    }

    public A withAuthorizerClass(java.lang.String authorizerClass) {
        this.authorizerClass=authorizerClass; return (A) this;
    }

    public java.lang.Boolean hasAuthorizerClass() {
        return this.authorizerClass != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAuthorizerClass instead.
     */
        public A withNewAuthorizerClass(java.lang.String original) {
        return (A)withAuthorizerClass(new String(original));
    }

    public A addToSuperUsers(int index,java.lang.String item) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        this.superUsers.add(index, item);
        return (A)this;
    }

    public A setToSuperUsers(int index,java.lang.String item) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        this.superUsers.set(index, item); return (A)this;
    }

    public A addToSuperUsers(java.lang.String... items) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A addAllToSuperUsers(java.util.Collection<java.lang.String> items) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A removeFromSuperUsers(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public A removeAllFromSuperUsers(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getSuperUsers() {
        return this.superUsers;
    }

    public java.lang.String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    public java.lang.String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    public java.lang.String getLastSuperUser() {
        return this.superUsers.get(superUsers.size() - 1);
    }

    public java.lang.String getMatchingSuperUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: superUsers) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingSuperUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: superUsers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSuperUsers(java.util.List<java.lang.String> superUsers) {
        if (this.superUsers != null) { _visitables.get("superUsers").removeAll(this.superUsers);}
        if (superUsers != null) {this.superUsers = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : superUsers){this.addToSuperUsers(item);}} else { this.superUsers = null;} return (A) this;
    }

    public A withSuperUsers(java.lang.String... superUsers) {
        if (this.superUsers != null) {this.superUsers.clear();}
        if (superUsers != null) {for (java.lang.String item :superUsers){ this.addToSuperUsers(item);}} return (A) this;
    }

    public java.lang.Boolean hasSuperUsers() {
        return superUsers != null && !superUsers.isEmpty();
    }

    public A addNewSuperUser(java.lang.String original) {
        return (A)addToSuperUsers(new String(original));
    }

    public boolean isSupportsAdminApi() {
        return this.supportsAdminApi;
    }

    public A withSupportsAdminApi(boolean supportsAdminApi) {
        this.supportsAdminApi=supportsAdminApi; return (A) this;
    }

    public java.lang.Boolean hasSupportsAdminApi() {
        return true;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaAuthorizationCustomFluentImpl that = (KafkaAuthorizationCustomFluentImpl) o;
        if (authorizerClass != null ? !authorizerClass.equals(that.authorizerClass) :that.authorizerClass != null) return false;
        if (superUsers != null ? !superUsers.equals(that.superUsers) :that.superUsers != null) return false;
        if (supportsAdminApi != that.supportsAdminApi) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(authorizerClass,  superUsers,  supportsAdminApi,  super.hashCode());
    }

}
