package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures Keycloak authorization on the brokers
   */
  public class KafkaAuthorizationKeycloakBuilder extends io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluentImpl<io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak,io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakBuilder> {

    io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaAuthorizationKeycloakBuilder() {
        this(true);
    }

    public KafkaAuthorizationKeycloakBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaAuthorizationKeycloak(), validationEnabled);
    }

    public KafkaAuthorizationKeycloakBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaAuthorizationKeycloakBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaAuthorizationKeycloak(), validationEnabled);
    }

    public KafkaAuthorizationKeycloakBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent<?> fluent,io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak instance) {
        this(fluent, instance, true);
    }

    public KafkaAuthorizationKeycloakBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent<?> fluent,io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClientId(instance.getClientId());
        
        fluent.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        fluent.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());
        
        fluent.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());
        
        fluent.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());
        
        fluent.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        
        fluent.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        
        fluent.withSuperUsers(instance.getSuperUsers());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaAuthorizationKeycloakBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak instance) {
        this(instance,true);
    }

    public KafkaAuthorizationKeycloakBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withClientId(instance.getClientId());
        
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        this.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());
        
        this.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());
        
        this.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());
        
        this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        
        this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        
        this.withSuperUsers(instance.getSuperUsers());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak build() {
        KafkaAuthorizationKeycloak buildable = new KafkaAuthorizationKeycloak();
        buildable.setClientId(fluent.getClientId());
        buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
        buildable.setTlsTrustedCertificates(fluent.getTlsTrustedCertificates());
        buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
        buildable.setDelegateToKafkaAcls(fluent.isDelegateToKafkaAcls());
        buildable.setGrantsRefreshPeriodSeconds(fluent.getGrantsRefreshPeriodSeconds());
        buildable.setGrantsRefreshPoolSize(fluent.getGrantsRefreshPoolSize());
        buildable.setConnectTimeoutSeconds(fluent.getConnectTimeoutSeconds());
        buildable.setReadTimeoutSeconds(fluent.getReadTimeoutSeconds());
        buildable.setSuperUsers(fluent.getSuperUsers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaAuthorizationKeycloakBuilder that = (KafkaAuthorizationKeycloakBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
