package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Configures Keycloak authorization on the brokers
   */
  public interface KafkaAuthorizationKeycloakFluent<A extends io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getClientId();
    public A withClientId(java.lang.String clientId);
    public java.lang.Boolean hasClientId();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientId instead.
     */
        public A withNewClientId(java.lang.String original);
    public java.lang.String getTokenEndpointUri();
    public A withTokenEndpointUri(java.lang.String tokenEndpointUri);
    public java.lang.Boolean hasTokenEndpointUri();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTokenEndpointUri instead.
     */
        public A withNewTokenEndpointUri(java.lang.String original);
    public A addToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item);
    public A setToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item);
    public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items);
    public A addAllToTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items);
    public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items);
    public A removeAllFromTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items);
    public A removeMatchingFromTlsTrustedCertificates(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> getTlsTrustedCertificates();
    public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> buildTlsTrustedCertificates();
    public io.strimzi.api.kafka.model.CertSecretSource buildTlsTrustedCertificate(int index);
    public io.strimzi.api.kafka.model.CertSecretSource buildFirstTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.CertSecretSource buildLastTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.CertSecretSource buildMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    public java.lang.Boolean hasMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    public A withTlsTrustedCertificates(java.util.List<io.strimzi.api.kafka.model.CertSecretSource> tlsTrustedCertificates);
    public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... tlsTrustedCertificates);
    public java.lang.Boolean hasTlsTrustedCertificates();
    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(io.strimzi.api.kafka.model.CertSecretSource item);
    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,io.strimzi.api.kafka.model.CertSecretSource item);
    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index);
    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    public boolean isDisableTlsHostnameVerification();
    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification);
    public java.lang.Boolean hasDisableTlsHostnameVerification();
    public boolean isDelegateToKafkaAcls();
    public A withDelegateToKafkaAcls(boolean delegateToKafkaAcls);
    public java.lang.Boolean hasDelegateToKafkaAcls();
    public java.lang.Integer getGrantsRefreshPeriodSeconds();
    public A withGrantsRefreshPeriodSeconds(java.lang.Integer grantsRefreshPeriodSeconds);
    public java.lang.Boolean hasGrantsRefreshPeriodSeconds();
    public java.lang.Integer getGrantsRefreshPoolSize();
    public A withGrantsRefreshPoolSize(java.lang.Integer grantsRefreshPoolSize);
    public java.lang.Boolean hasGrantsRefreshPoolSize();
    public java.lang.Integer getConnectTimeoutSeconds();
    public A withConnectTimeoutSeconds(java.lang.Integer connectTimeoutSeconds);
    public java.lang.Boolean hasConnectTimeoutSeconds();
    public java.lang.Integer getReadTimeoutSeconds();
    public A withReadTimeoutSeconds(java.lang.Integer readTimeoutSeconds);
    public java.lang.Boolean hasReadTimeoutSeconds();
    public A addToSuperUsers(int index,java.lang.String item);
    public A setToSuperUsers(int index,java.lang.String item);
    public A addToSuperUsers(java.lang.String... items);
    public A addAllToSuperUsers(java.util.Collection<java.lang.String> items);
    public A removeFromSuperUsers(java.lang.String... items);
    public A removeAllFromSuperUsers(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getSuperUsers();
    public java.lang.String getSuperUser(int index);
    public java.lang.String getFirstSuperUser();
    public java.lang.String getLastSuperUser();
    public java.lang.String getMatchingSuperUser(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingSuperUser(java.util.function.Predicate<java.lang.String> predicate);
    public A withSuperUsers(java.util.List<java.lang.String> superUsers);
    public A withSuperUsers(java.lang.String... superUsers);
    public java.lang.Boolean hasSuperUsers();
    public A addNewSuperUser(java.lang.String original);
      
  /**
   * Represents a certificate inside a Secret
   */
  public interface TlsTrustedCertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.CertSecretSourceFluent<io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<N>> {

            public N and();
            public N endTlsTrustedCertificate();    }


}
