package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Configures Keycloak authorization on the brokers
   */
  public class KafkaAuthorizationKeycloakFluentImpl<A extends io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent<A> {

    private java.lang.String clientId;
    private java.lang.String tokenEndpointUri;
    private java.util.List<io.strimzi.api.kafka.model.CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private boolean delegateToKafkaAcls;
    private java.lang.Integer grantsRefreshPeriodSeconds;
    private java.lang.Integer grantsRefreshPoolSize;
    private java.lang.Integer connectTimeoutSeconds;
    private java.lang.Integer readTimeoutSeconds;
    private java.util.List<java.lang.String> superUsers;

    public KafkaAuthorizationKeycloakFluentImpl() {
    }

    public KafkaAuthorizationKeycloakFluentImpl(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak instance) {
        this.withClientId(instance.getClientId());
        
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        this.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());
        
        this.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());
        
        this.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());
        
        this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        
        this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        
        this.withSuperUsers(instance.getSuperUsers());
    }

    public java.lang.String getClientId() {
        return this.clientId;
    }

    public A withClientId(java.lang.String clientId) {
        this.clientId=clientId; return (A) this;
    }

    public java.lang.Boolean hasClientId() {
        return this.clientId != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientId instead.
     */
        public A withNewClientId(java.lang.String original) {
        return (A)withClientId(new String(original));
    }

    public java.lang.String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public A withTokenEndpointUri(java.lang.String tokenEndpointUri) {
        this.tokenEndpointUri=tokenEndpointUri; return (A) this;
    }

    public java.lang.Boolean hasTokenEndpointUri() {
        return this.tokenEndpointUri != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTokenEndpointUri instead.
     */
        public A withNewTokenEndpointUri(java.lang.String original) {
        return (A)withTokenEndpointUri(new String(original));
    }

    public A addToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(index >= 0 ? index : _visitables.get("tlsTrustedCertificates").size(), builder);this.tlsTrustedCertificates.add(index >= 0 ? index : tlsTrustedCertificates.size(), builder); return (A)this;
    }

    public A setToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("tlsTrustedCertificates").size()) { _visitables.get("tlsTrustedCertificates").add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder);}
        if (index < 0 || index >= tlsTrustedCertificates.size()) { tlsTrustedCertificates.add(builder); } else { tlsTrustedCertificates.set(index, builder);}
         return (A)this;
    }

    public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A addAllToTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items) {
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTlsTrustedCertificates(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        if (tlsTrustedCertificates == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
        final List visitables = _visitables.get("tlsTrustedCertificates");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> getTlsTrustedCertificates() {
        return build(tlsTrustedCertificates);
    }

    public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> buildTlsTrustedCertificates() {
        return build(tlsTrustedCertificates);
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTlsTrustedCertificates(java.util.List<io.strimzi.api.kafka.model.CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) { _visitables.get("tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);}
        if (tlsTrustedCertificates != null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>(); for (io.strimzi.api.kafka.model.CertSecretSource item : tlsTrustedCertificates){this.addToTlsTrustedCertificates(item);}} else { this.tlsTrustedCertificates = null;} return (A) this;
    }

    public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.clear();}
        if (tlsTrustedCertificates != null) {for (io.strimzi.api.kafka.model.CertSecretSource item :tlsTrustedCertificates){ this.addToTlsTrustedCertificates(item);}} return (A) this;
    }

    public java.lang.Boolean hasTlsTrustedCertificates() {
        return tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty();
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluentImpl.TlsTrustedCertificatesNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(io.strimzi.api.kafka.model.CertSecretSource item) {
        return new io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluentImpl.TlsTrustedCertificatesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        return new io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluentImpl.TlsTrustedCertificatesNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = tlsTrustedCertificates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tlsTrustedCertificates.size();i++) { 
        if (predicate.test(tlsTrustedCertificates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification=disableTlsHostnameVerification; return (A) this;
    }

    public java.lang.Boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    public boolean isDelegateToKafkaAcls() {
        return this.delegateToKafkaAcls;
    }

    public A withDelegateToKafkaAcls(boolean delegateToKafkaAcls) {
        this.delegateToKafkaAcls=delegateToKafkaAcls; return (A) this;
    }

    public java.lang.Boolean hasDelegateToKafkaAcls() {
        return true;
    }

    public java.lang.Integer getGrantsRefreshPeriodSeconds() {
        return this.grantsRefreshPeriodSeconds;
    }

    public A withGrantsRefreshPeriodSeconds(java.lang.Integer grantsRefreshPeriodSeconds) {
        this.grantsRefreshPeriodSeconds=grantsRefreshPeriodSeconds; return (A) this;
    }

    public java.lang.Boolean hasGrantsRefreshPeriodSeconds() {
        return this.grantsRefreshPeriodSeconds != null;
    }

    public java.lang.Integer getGrantsRefreshPoolSize() {
        return this.grantsRefreshPoolSize;
    }

    public A withGrantsRefreshPoolSize(java.lang.Integer grantsRefreshPoolSize) {
        this.grantsRefreshPoolSize=grantsRefreshPoolSize; return (A) this;
    }

    public java.lang.Boolean hasGrantsRefreshPoolSize() {
        return this.grantsRefreshPoolSize != null;
    }

    public java.lang.Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public A withConnectTimeoutSeconds(java.lang.Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds=connectTimeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds != null;
    }

    public java.lang.Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public A withReadTimeoutSeconds(java.lang.Integer readTimeoutSeconds) {
        this.readTimeoutSeconds=readTimeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasReadTimeoutSeconds() {
        return this.readTimeoutSeconds != null;
    }

    public A addToSuperUsers(int index,java.lang.String item) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        this.superUsers.add(index, item);
        return (A)this;
    }

    public A setToSuperUsers(int index,java.lang.String item) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        this.superUsers.set(index, item); return (A)this;
    }

    public A addToSuperUsers(java.lang.String... items) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A addAllToSuperUsers(java.util.Collection<java.lang.String> items) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A removeFromSuperUsers(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public A removeAllFromSuperUsers(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getSuperUsers() {
        return this.superUsers;
    }

    public java.lang.String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    public java.lang.String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    public java.lang.String getLastSuperUser() {
        return this.superUsers.get(superUsers.size() - 1);
    }

    public java.lang.String getMatchingSuperUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: superUsers) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingSuperUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: superUsers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSuperUsers(java.util.List<java.lang.String> superUsers) {
        if (this.superUsers != null) { _visitables.get("superUsers").removeAll(this.superUsers);}
        if (superUsers != null) {this.superUsers = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : superUsers){this.addToSuperUsers(item);}} else { this.superUsers = null;} return (A) this;
    }

    public A withSuperUsers(java.lang.String... superUsers) {
        if (this.superUsers != null) {this.superUsers.clear();}
        if (superUsers != null) {for (java.lang.String item :superUsers){ this.addToSuperUsers(item);}} return (A) this;
    }

    public java.lang.Boolean hasSuperUsers() {
        return superUsers != null && !superUsers.isEmpty();
    }

    public A addNewSuperUser(java.lang.String original) {
        return (A)addToSuperUsers(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaAuthorizationKeycloakFluentImpl that = (KafkaAuthorizationKeycloakFluentImpl) o;
        if (clientId != null ? !clientId.equals(that.clientId) :that.clientId != null) return false;
        if (tokenEndpointUri != null ? !tokenEndpointUri.equals(that.tokenEndpointUri) :that.tokenEndpointUri != null) return false;
        if (tlsTrustedCertificates != null ? !tlsTrustedCertificates.equals(that.tlsTrustedCertificates) :that.tlsTrustedCertificates != null) return false;
        if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
        if (delegateToKafkaAcls != that.delegateToKafkaAcls) return false;
        if (grantsRefreshPeriodSeconds != null ? !grantsRefreshPeriodSeconds.equals(that.grantsRefreshPeriodSeconds) :that.grantsRefreshPeriodSeconds != null) return false;
        if (grantsRefreshPoolSize != null ? !grantsRefreshPoolSize.equals(that.grantsRefreshPoolSize) :that.grantsRefreshPoolSize != null) return false;
        if (connectTimeoutSeconds != null ? !connectTimeoutSeconds.equals(that.connectTimeoutSeconds) :that.connectTimeoutSeconds != null) return false;
        if (readTimeoutSeconds != null ? !readTimeoutSeconds.equals(that.readTimeoutSeconds) :that.readTimeoutSeconds != null) return false;
        if (superUsers != null ? !superUsers.equals(that.superUsers) :that.superUsers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clientId,  tokenEndpointUri,  tlsTrustedCertificates,  disableTlsHostnameVerification,  delegateToKafkaAcls,  grantsRefreshPeriodSeconds,  grantsRefreshPoolSize,  connectTimeoutSeconds,  readTimeoutSeconds,  superUsers,  super.hashCode());
    }

      
  /**
   * Represents a certificate inside a Secret
   */
  public class TlsTrustedCertificatesNestedImpl<N> extends io.strimzi.api.kafka.model.CertSecretSourceFluentImpl<io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<N>> implements io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.CertSecretSourceBuilder builder;
        private final int index;

            TlsTrustedCertificatesNestedImpl(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(this, item);
                        
            }

            TlsTrustedCertificatesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaAuthorizationKeycloakFluentImpl.this.setToTlsTrustedCertificates(index,builder.build());
            }

            public N endTlsTrustedCertificate() {
                return and();
            }
    }


}
