package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures the broker authorization to use Open Policy Agent as an authorization and policy server.
   */
  public class KafkaAuthorizationOpaBuilder extends io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluentImpl<io.strimzi.api.kafka.model.KafkaAuthorizationOpaBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaAuthorizationOpa,io.strimzi.api.kafka.model.KafkaAuthorizationOpaBuilder> {

    io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaAuthorizationOpaBuilder() {
        this(true);
    }

    public KafkaAuthorizationOpaBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaAuthorizationOpa(), validationEnabled);
    }

    public KafkaAuthorizationOpaBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaAuthorizationOpaBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaAuthorizationOpa(), validationEnabled);
    }

    public KafkaAuthorizationOpaBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent<?> fluent,io.strimzi.api.kafka.model.KafkaAuthorizationOpa instance) {
        this(fluent, instance, true);
    }

    public KafkaAuthorizationOpaBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent<?> fluent,io.strimzi.api.kafka.model.KafkaAuthorizationOpa instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSuperUsers(instance.getSuperUsers());
        
        fluent.withUrl(instance.getUrl());
        
        fluent.withAllowOnError(instance.isAllowOnError());
        
        fluent.withInitialCacheCapacity(instance.getInitialCacheCapacity());
        
        fluent.withMaximumCacheSize(instance.getMaximumCacheSize());
        
        fluent.withExpireAfterMs(instance.getExpireAfterMs());
        
        fluent.withEnableMetrics(instance.isEnableMetrics());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaAuthorizationOpaBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationOpa instance) {
        this(instance,true);
    }

    public KafkaAuthorizationOpaBuilder(io.strimzi.api.kafka.model.KafkaAuthorizationOpa instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSuperUsers(instance.getSuperUsers());
        
        this.withUrl(instance.getUrl());
        
        this.withAllowOnError(instance.isAllowOnError());
        
        this.withInitialCacheCapacity(instance.getInitialCacheCapacity());
        
        this.withMaximumCacheSize(instance.getMaximumCacheSize());
        
        this.withExpireAfterMs(instance.getExpireAfterMs());
        
        this.withEnableMetrics(instance.isEnableMetrics());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaAuthorizationOpa build() {
        KafkaAuthorizationOpa buildable = new KafkaAuthorizationOpa();
        buildable.setSuperUsers(fluent.getSuperUsers());
        buildable.setUrl(fluent.getUrl());
        buildable.setAllowOnError(fluent.isAllowOnError());
        buildable.setInitialCacheCapacity(fluent.getInitialCacheCapacity());
        buildable.setMaximumCacheSize(fluent.getMaximumCacheSize());
        buildable.setExpireAfterMs(fluent.getExpireAfterMs());
        buildable.setEnableMetrics(fluent.isEnableMetrics());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaAuthorizationOpaBuilder that = (KafkaAuthorizationOpaBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
