package io.strimzi.api.kafka.model;

import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.function.Predicate;

  
  /**
   * Configures the broker authorization to use Open Policy Agent as an authorization and policy server.
   */
  public class KafkaAuthorizationOpaFluentImpl<A extends io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent<A> {

    private java.util.List<java.lang.String> superUsers;
    private java.lang.String url;
    private boolean allowOnError;
    private int initialCacheCapacity;
    private int maximumCacheSize;
    private long expireAfterMs;
    private boolean enableMetrics;

    public KafkaAuthorizationOpaFluentImpl() {
    }

    public KafkaAuthorizationOpaFluentImpl(io.strimzi.api.kafka.model.KafkaAuthorizationOpa instance) {
        this.withSuperUsers(instance.getSuperUsers());
        
        this.withUrl(instance.getUrl());
        
        this.withAllowOnError(instance.isAllowOnError());
        
        this.withInitialCacheCapacity(instance.getInitialCacheCapacity());
        
        this.withMaximumCacheSize(instance.getMaximumCacheSize());
        
        this.withExpireAfterMs(instance.getExpireAfterMs());
        
        this.withEnableMetrics(instance.isEnableMetrics());
    }

    public A addToSuperUsers(int index,java.lang.String item) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        this.superUsers.add(index, item);
        return (A)this;
    }

    public A setToSuperUsers(int index,java.lang.String item) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        this.superUsers.set(index, item); return (A)this;
    }

    public A addToSuperUsers(java.lang.String... items) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A addAllToSuperUsers(java.util.Collection<java.lang.String> items) {
        if (this.superUsers == null) {this.superUsers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A removeFromSuperUsers(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public A removeAllFromSuperUsers(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getSuperUsers() {
        return this.superUsers;
    }

    public java.lang.String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    public java.lang.String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    public java.lang.String getLastSuperUser() {
        return this.superUsers.get(superUsers.size() - 1);
    }

    public java.lang.String getMatchingSuperUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: superUsers) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingSuperUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: superUsers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSuperUsers(java.util.List<java.lang.String> superUsers) {
        if (this.superUsers != null) { _visitables.get("superUsers").removeAll(this.superUsers);}
        if (superUsers != null) {this.superUsers = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : superUsers){this.addToSuperUsers(item);}} else { this.superUsers = null;} return (A) this;
    }

    public A withSuperUsers(java.lang.String... superUsers) {
        if (this.superUsers != null) {this.superUsers.clear();}
        if (superUsers != null) {for (java.lang.String item :superUsers){ this.addToSuperUsers(item);}} return (A) this;
    }

    public java.lang.Boolean hasSuperUsers() {
        return superUsers != null && !superUsers.isEmpty();
    }

    public A addNewSuperUser(java.lang.String original) {
        return (A)addToSuperUsers(new String(original));
    }

    public java.lang.String getUrl() {
        return this.url;
    }

    public A withUrl(java.lang.String url) {
        this.url=url; return (A) this;
    }

    public java.lang.Boolean hasUrl() {
        return this.url != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUrl instead.
     */
        public A withNewUrl(java.lang.String original) {
        return (A)withUrl(new String(original));
    }

    public boolean isAllowOnError() {
        return this.allowOnError;
    }

    public A withAllowOnError(boolean allowOnError) {
        this.allowOnError=allowOnError; return (A) this;
    }

    public java.lang.Boolean hasAllowOnError() {
        return true;
    }

    public int getInitialCacheCapacity() {
        return this.initialCacheCapacity;
    }

    public A withInitialCacheCapacity(int initialCacheCapacity) {
        this.initialCacheCapacity=initialCacheCapacity; return (A) this;
    }

    public java.lang.Boolean hasInitialCacheCapacity() {
        return true;
    }

    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public A withMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize=maximumCacheSize; return (A) this;
    }

    public java.lang.Boolean hasMaximumCacheSize() {
        return true;
    }

    public long getExpireAfterMs() {
        return this.expireAfterMs;
    }

    public A withExpireAfterMs(long expireAfterMs) {
        this.expireAfterMs=expireAfterMs; return (A) this;
    }

    public java.lang.Boolean hasExpireAfterMs() {
        return true;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public A withEnableMetrics(boolean enableMetrics) {
        this.enableMetrics=enableMetrics; return (A) this;
    }

    public java.lang.Boolean hasEnableMetrics() {
        return true;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaAuthorizationOpaFluentImpl that = (KafkaAuthorizationOpaFluentImpl) o;
        if (superUsers != null ? !superUsers.equals(that.superUsers) :that.superUsers != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        if (allowOnError != that.allowOnError) return false;
        if (initialCacheCapacity != that.initialCacheCapacity) return false;
        if (maximumCacheSize != that.maximumCacheSize) return false;
        if (expireAfterMs != that.expireAfterMs) return false;
        if (enableMetrics != that.enableMetrics) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(superUsers,  url,  allowOnError,  initialCacheCapacity,  maximumCacheSize,  expireAfterMs,  enableMetrics,  super.hashCode());
    }

}
