package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeBuilder extends io.strimzi.api.kafka.model.KafkaBridgeFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaBridge,io.strimzi.api.kafka.model.KafkaBridgeBuilder> {

    io.strimzi.api.kafka.model.KafkaBridgeFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaBridgeBuilder() {
        this(true);
    }

    public KafkaBridgeBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaBridge(), validationEnabled);
    }

    public KafkaBridgeBuilder(io.strimzi.api.kafka.model.KafkaBridgeFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeBuilder(io.strimzi.api.kafka.model.KafkaBridgeFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaBridge(), validationEnabled);
    }

    public KafkaBridgeBuilder(io.strimzi.api.kafka.model.KafkaBridgeFluent<?> fluent,io.strimzi.api.kafka.model.KafkaBridge instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeBuilder(io.strimzi.api.kafka.model.KafkaBridgeFluent<?> fluent,io.strimzi.api.kafka.model.KafkaBridge instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withKind(instance.getKind());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeBuilder(io.strimzi.api.kafka.model.KafkaBridge instance) {
        this(instance,true);
    }

    public KafkaBridgeBuilder(io.strimzi.api.kafka.model.KafkaBridge instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaBridge build() {
        KafkaBridge buildable = new KafkaBridge();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeBuilder that = (KafkaBridgeBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
