package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeConsumerSpecBuilder extends io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec,io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaBridgeConsumerSpecBuilder() {
        this(true);
    }

    public KafkaBridgeConsumerSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaBridgeConsumerSpec(), validationEnabled);
    }

    public KafkaBridgeConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaBridgeConsumerSpec(), validationEnabled);
    }

    public KafkaBridgeConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec instance) {
        this(instance,true);
    }

    public KafkaBridgeConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec build() {
        KafkaBridgeConsumerSpec buildable = new KafkaBridgeConsumerSpec();
        buildable.setConfig(fluent.getConfig());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeConsumerSpecBuilder that = (KafkaBridgeConsumerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
