package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * A representation of the HTTP configuration.
   */
  public class KafkaBridgeHttpConfigBuilder extends io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeHttpConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaBridgeHttpConfig,io.strimzi.api.kafka.model.KafkaBridgeHttpConfigBuilder> {

    io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaBridgeHttpConfigBuilder() {
        this(true);
    }

    public KafkaBridgeHttpConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaBridgeHttpConfig(), validationEnabled);
    }

    public KafkaBridgeHttpConfigBuilder(io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeHttpConfigBuilder(io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaBridgeHttpConfig(), validationEnabled);
    }

    public KafkaBridgeHttpConfigBuilder(io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluent<?> fluent,io.strimzi.api.kafka.model.KafkaBridgeHttpConfig instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeHttpConfigBuilder(io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluent<?> fluent,io.strimzi.api.kafka.model.KafkaBridgeHttpConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPort(instance.getPort()); 
        fluent.withCors(instance.getCors());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeHttpConfigBuilder(io.strimzi.api.kafka.model.KafkaBridgeHttpConfig instance) {
        this(instance,true);
    }

    public KafkaBridgeHttpConfigBuilder(io.strimzi.api.kafka.model.KafkaBridgeHttpConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPort(instance.getPort()); 
        this.withCors(instance.getCors());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaBridgeHttpConfig build() {
        KafkaBridgeHttpConfig buildable = new KafkaBridgeHttpConfig(fluent.getPort());
        buildable.setCors(fluent.getCors());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeHttpConfigBuilder that = (KafkaBridgeHttpConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
