package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.function.Predicate;

  
  /**
   * A representation of the HTTP CORS configuration.
   */
  public class KafkaBridgeHttpCorsFluentImpl<A extends io.strimzi.api.kafka.model.KafkaBridgeHttpCorsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaBridgeHttpCorsFluent<A> {

    private java.util.List<java.lang.String> allowedOrigins;
    private java.util.List<java.lang.String> allowedMethods;

    public KafkaBridgeHttpCorsFluentImpl() {
    }

    public KafkaBridgeHttpCorsFluentImpl(io.strimzi.api.kafka.model.KafkaBridgeHttpCors instance) {
        this.withAllowedOrigins(instance.getAllowedOrigins());
        
        this.withAllowedMethods(instance.getAllowedMethods());
    }

    public A addToAllowedOrigins(int index,java.lang.String item) {
        if (this.allowedOrigins == null) {this.allowedOrigins = new java.util.ArrayList<java.lang.String>();}
        this.allowedOrigins.add(index, item);
        return (A)this;
    }

    public A setToAllowedOrigins(int index,java.lang.String item) {
        if (this.allowedOrigins == null) {this.allowedOrigins = new java.util.ArrayList<java.lang.String>();}
        this.allowedOrigins.set(index, item); return (A)this;
    }

    public A addToAllowedOrigins(java.lang.String... items) {
        if (this.allowedOrigins == null) {this.allowedOrigins = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.allowedOrigins.add(item);} return (A)this;
    }

    public A addAllToAllowedOrigins(java.util.Collection<java.lang.String> items) {
        if (this.allowedOrigins == null) {this.allowedOrigins = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.allowedOrigins.add(item);} return (A)this;
    }

    public A removeFromAllowedOrigins(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.allowedOrigins!= null){ this.allowedOrigins.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedOrigins(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.allowedOrigins!= null){ this.allowedOrigins.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public java.lang.String getAllowedOrigin(int index) {
        return this.allowedOrigins.get(index);
    }

    public java.lang.String getFirstAllowedOrigin() {
        return this.allowedOrigins.get(0);
    }

    public java.lang.String getLastAllowedOrigin() {
        return this.allowedOrigins.get(allowedOrigins.size() - 1);
    }

    public java.lang.String getMatchingAllowedOrigin(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: allowedOrigins) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingAllowedOrigin(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: allowedOrigins) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAllowedOrigins(java.util.List<java.lang.String> allowedOrigins) {
        if (this.allowedOrigins != null) { _visitables.get("allowedOrigins").removeAll(this.allowedOrigins);}
        if (allowedOrigins != null) {this.allowedOrigins = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : allowedOrigins){this.addToAllowedOrigins(item);}} else { this.allowedOrigins = null;} return (A) this;
    }

    public A withAllowedOrigins(java.lang.String... allowedOrigins) {
        if (this.allowedOrigins != null) {this.allowedOrigins.clear();}
        if (allowedOrigins != null) {for (java.lang.String item :allowedOrigins){ this.addToAllowedOrigins(item);}} return (A) this;
    }

    public java.lang.Boolean hasAllowedOrigins() {
        return allowedOrigins != null && !allowedOrigins.isEmpty();
    }

    public A addNewAllowedOrigin(java.lang.String original) {
        return (A)addToAllowedOrigins(new String(original));
    }

    public A addToAllowedMethods(int index,java.lang.String item) {
        if (this.allowedMethods == null) {this.allowedMethods = new java.util.ArrayList<java.lang.String>();}
        this.allowedMethods.add(index, item);
        return (A)this;
    }

    public A setToAllowedMethods(int index,java.lang.String item) {
        if (this.allowedMethods == null) {this.allowedMethods = new java.util.ArrayList<java.lang.String>();}
        this.allowedMethods.set(index, item); return (A)this;
    }

    public A addToAllowedMethods(java.lang.String... items) {
        if (this.allowedMethods == null) {this.allowedMethods = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.allowedMethods.add(item);} return (A)this;
    }

    public A addAllToAllowedMethods(java.util.Collection<java.lang.String> items) {
        if (this.allowedMethods == null) {this.allowedMethods = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.allowedMethods.add(item);} return (A)this;
    }

    public A removeFromAllowedMethods(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.allowedMethods!= null){ this.allowedMethods.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedMethods(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.allowedMethods!= null){ this.allowedMethods.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public java.lang.String getAllowedMethod(int index) {
        return this.allowedMethods.get(index);
    }

    public java.lang.String getFirstAllowedMethod() {
        return this.allowedMethods.get(0);
    }

    public java.lang.String getLastAllowedMethod() {
        return this.allowedMethods.get(allowedMethods.size() - 1);
    }

    public java.lang.String getMatchingAllowedMethod(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: allowedMethods) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingAllowedMethod(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: allowedMethods) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAllowedMethods(java.util.List<java.lang.String> allowedMethods) {
        if (this.allowedMethods != null) { _visitables.get("allowedMethods").removeAll(this.allowedMethods);}
        if (allowedMethods != null) {this.allowedMethods = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : allowedMethods){this.addToAllowedMethods(item);}} else { this.allowedMethods = null;} return (A) this;
    }

    public A withAllowedMethods(java.lang.String... allowedMethods) {
        if (this.allowedMethods != null) {this.allowedMethods.clear();}
        if (allowedMethods != null) {for (java.lang.String item :allowedMethods){ this.addToAllowedMethods(item);}} return (A) this;
    }

    public java.lang.Boolean hasAllowedMethods() {
        return allowedMethods != null && !allowedMethods.isEmpty();
    }

    public A addNewAllowedMethod(java.lang.String original) {
        return (A)addToAllowedMethods(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaBridgeHttpCorsFluentImpl that = (KafkaBridgeHttpCorsFluentImpl) o;
        if (allowedOrigins != null ? !allowedOrigins.equals(that.allowedOrigins) :that.allowedOrigins != null) return false;
        if (allowedMethods != null ? !allowedMethods.equals(that.allowedMethods) :that.allowedMethods != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allowedOrigins,  allowedMethods,  super.hashCode());
    }

}
