package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeSpecBuilder extends io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaBridgeSpec,io.strimzi.api.kafka.model.KafkaBridgeSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaBridgeSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaBridgeSpecBuilder() {
        this(true);
    }

    public KafkaBridgeSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaBridgeSpec(), validationEnabled);
    }

    public KafkaBridgeSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaBridgeSpec(), validationEnabled);
    }

    public KafkaBridgeSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaBridgeSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaBridgeSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withImage(instance.getImage());
        
        fluent.withHttp(instance.getHttp());
        
        fluent.withBootstrapServers(instance.getBootstrapServers());
        
        fluent.withTls(instance.getTls());
        
        fluent.withAuthentication(instance.getAuthentication());
        
        fluent.withConsumer(instance.getConsumer());
        
        fluent.withProducer(instance.getProducer());
        
        fluent.withAdminClient(instance.getAdminClient());
        
        fluent.withResources(instance.getResources());
        
        fluent.withJvmOptions(instance.getJvmOptions());
        
        fluent.withLogging(instance.getLogging());
        
        fluent.withEnableMetrics(instance.getEnableMetrics());
        
        fluent.withLivenessProbe(instance.getLivenessProbe());
        
        fluent.withReadinessProbe(instance.getReadinessProbe());
        
        fluent.withTemplate(instance.getTemplate());
        
        fluent.withTracing(instance.getTracing());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeSpec instance) {
        this(instance,true);
    }

    public KafkaBridgeSpecBuilder(io.strimzi.api.kafka.model.KafkaBridgeSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withReplicas(instance.getReplicas());
        
        this.withImage(instance.getImage());
        
        this.withHttp(instance.getHttp());
        
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
        
        this.withConsumer(instance.getConsumer());
        
        this.withProducer(instance.getProducer());
        
        this.withAdminClient(instance.getAdminClient());
        
        this.withResources(instance.getResources());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withLogging(instance.getLogging());
        
        this.withEnableMetrics(instance.getEnableMetrics());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withTemplate(instance.getTemplate());
        
        this.withTracing(instance.getTracing());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpec build() {
        KafkaBridgeSpec buildable = new KafkaBridgeSpec();
        buildable.setReplicas(fluent.getReplicas());
        buildable.setImage(fluent.getImage());
        buildable.setHttp(fluent.getHttp());
        buildable.setBootstrapServers(fluent.getBootstrapServers());
        buildable.setTls(fluent.getTls());
        buildable.setAuthentication(fluent.getAuthentication());
        buildable.setConsumer(fluent.getConsumer());
        buildable.setProducer(fluent.getProducer());
        buildable.setAdminClient(fluent.getAdminClient());
        buildable.setResources(fluent.getResources());
        buildable.setJvmOptions(fluent.getJvmOptions());
        buildable.setLogging(fluent.getLogging());
        buildable.setEnableMetrics(fluent.isEnableMetrics());
        buildable.setLivenessProbe(fluent.getLivenessProbe());
        buildable.setReadinessProbe(fluent.getReadinessProbe());
        buildable.setTemplate(fluent.getTemplate());
        buildable.setTracing(fluent.getTracing());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeSpecBuilder that = (KafkaBridgeSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
