package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplate;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluent;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder;
import io.strimzi.api.kafka.model.tracing.Tracing;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent;

public interface KafkaBridgeSpecFluent<A extends io.strimzi.api.kafka.model.KafkaBridgeSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluent<A> {


    public int getReplicas();
    public A withReplicas(int replicas);
    public java.lang.Boolean hasReplicas();
    public java.lang.String getImage();
    public A withImage(java.lang.String image);
    public java.lang.Boolean hasImage();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildHttp instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaBridgeHttpConfig getHttp();
    public io.strimzi.api.kafka.model.KafkaBridgeHttpConfig buildHttp();
    public A withHttp(io.strimzi.api.kafka.model.KafkaBridgeHttpConfig http);
    public java.lang.Boolean hasHttp();
    public A withNewHttp(int port);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> withNewHttp();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> withNewHttpLike(io.strimzi.api.kafka.model.KafkaBridgeHttpConfig item);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> editHttp();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttp();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttpLike(io.strimzi.api.kafka.model.KafkaBridgeHttpConfig item);
    public java.lang.String getBootstrapServers();
    public A withBootstrapServers(java.lang.String bootstrapServers);
    public java.lang.Boolean hasBootstrapServers();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBootstrapServers instead.
     */
        public A withNewBootstrapServers(java.lang.String original);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTls instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.ClientTls getTls();
    public io.strimzi.api.kafka.model.ClientTls buildTls();
    public A withTls(io.strimzi.api.kafka.model.ClientTls tls);
    public java.lang.Boolean hasTls();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> withNewTls();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> withNewTlsLike(io.strimzi.api.kafka.model.ClientTls item);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> editTls();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> editOrNewTls();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> editOrNewTlsLike(io.strimzi.api.kafka.model.ClientTls item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuthentication instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication getAuthentication();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication buildAuthentication();
    public A withAuthentication(io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication authentication);
    public java.lang.Boolean hasAuthentication();
    public A withKafkaClientAuthenticationScramSha512(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 item);
    public A withKafkaClientAuthenticationScramSha256(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 kafkaClientAuthenticationScramSha256);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 item);
    public A withKafkaClientAuthenticationPlain(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain item);
    public A withKafkaClientAuthenticationOAuth(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth item);
    public A withKafkaClientAuthenticationTls(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls kafkaClientAuthenticationTls);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConsumer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec getConsumer();
    public io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec buildConsumer();
    public A withConsumer(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec consumer);
    public java.lang.Boolean hasConsumer();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumer();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumerLike(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec item);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> editConsumer();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumer();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumerLike(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildProducer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaBridgeProducerSpec getProducer();
    public io.strimzi.api.kafka.model.KafkaBridgeProducerSpec buildProducer();
    public A withProducer(io.strimzi.api.kafka.model.KafkaBridgeProducerSpec producer);
    public java.lang.Boolean hasProducer();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> withNewProducer();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> withNewProducerLike(io.strimzi.api.kafka.model.KafkaBridgeProducerSpec item);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> editProducer();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducer();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducerLike(io.strimzi.api.kafka.model.KafkaBridgeProducerSpec item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAdminClient instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec getAdminClient();
    public io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec buildAdminClient();
    public A withAdminClient(io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec adminClient);
    public java.lang.Boolean hasAdminClient();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> withNewAdminClient();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> withNewAdminClientLike(io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec item);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> editAdminClient();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> editOrNewAdminClient();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> editOrNewAdminClientLike(io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec item);
    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources();
    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources);
    public java.lang.Boolean hasResources();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJvmOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JvmOptions getJvmOptions();
    public io.strimzi.api.kafka.model.JvmOptions buildJvmOptions();
    public A withJvmOptions(io.strimzi.api.kafka.model.JvmOptions jvmOptions);
    public java.lang.Boolean hasJvmOptions();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptions();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> editJvmOptions();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Logging getLogging();
    public io.strimzi.api.kafka.model.Logging buildLogging();
    public A withLogging(io.strimzi.api.kafka.model.Logging logging);
    public java.lang.Boolean hasLogging();
    public A withExternalLogging(io.strimzi.api.kafka.model.ExternalLogging externalLogging);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLogging();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(io.strimzi.api.kafka.model.ExternalLogging item);
    public A withInlineLogging(io.strimzi.api.kafka.model.InlineLogging inlineLogging);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLogging();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(io.strimzi.api.kafka.model.InlineLogging item);
    public boolean isEnableMetrics();
    public A withEnableMetrics(boolean enableMetrics);
    public java.lang.Boolean hasEnableMetrics();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe();
    public io.strimzi.api.kafka.model.Probe buildLivenessProbe();
    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe);
    public java.lang.Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe();
    public io.strimzi.api.kafka.model.Probe buildReadinessProbe();
    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe);
    public java.lang.Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.KafkaBridgeTemplate getTemplate();
    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplate buildTemplate();
    public A withTemplate(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate template);
    public java.lang.Boolean hasTemplate();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplate();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate item);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> editTemplate();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTracing instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.tracing.Tracing getTracing();
    public io.strimzi.api.kafka.model.tracing.Tracing buildTracing();
    public A withTracing(io.strimzi.api.kafka.model.tracing.Tracing tracing);
    public java.lang.Boolean hasTracing();
    public A withJaegerTracing(io.strimzi.api.kafka.model.tracing.JaegerTracing jaegerTracing);
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracing();
    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(io.strimzi.api.kafka.model.tracing.JaegerTracing item);
      
  /**
   * A representation of the HTTP configuration.
   */
  public interface HttpNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<N>> {

            public N and();
            public N endHttp();    }


      
  /**
   * Represent the TLS configuration for all the Clients(KafkaConnect, KafkaBridge, KafkaMirrorMaker, KafkaMirrorMaker2).
   */
  public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ClientTlsFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<N>> {

            public N and();
            public N endTls();    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_512 in client based components
   */
  public interface KafkaClientAuthenticationScramSha512Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>> {

            public N and();
            public N endKafkaClientAuthenticationScramSha512();    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_256 in client based components
   */
  public interface KafkaClientAuthenticationScramSha256Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha256Nested<N>> {

            public N and();
            public N endKafkaClientAuthenticationScramSha256();    }


      
  /**
   * Configures the Kafka client authentication using SASL PLAIN in client based components
   */
  public interface KafkaClientAuthenticationPlainNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationPlain();    }


      
  /**
   * Configures the Kafka client authentication using SASl OAUTHBEARER mechanism in client based components
   */
  public interface KafkaClientAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationOAuth();    }


      
  /**
   * Configures the Kafka client authentication using TLS client authentication in client based components
   */
  public interface KafkaClientAuthenticationTlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationTls();    }


    public interface ConsumerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<N>> {

            public N and();
            public N endConsumer();    }


    public interface ProducerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaBridgeProducerSpecFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<N>> {

            public N and();
            public N endProducer();    }


    public interface AdminClientNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<N>> {

            public N and();
            public N endAdminClient();    }


      
  /**
   * Representation for options to be passed to a JVM.
   */
  public interface JvmOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.JvmOptionsFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<N>> {

            public N and();
            public N endJvmOptions();    }


      
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public interface ExternalLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ExternalLoggingFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ExternalLoggingNested<N>> {

            public N and();
            public N endExternalLogging();    }


      
  /**
   * Logging config is given inline with the resource
   */
  public interface InlineLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.InlineLoggingFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.InlineLoggingNested<N>> {

            public N and();
            public N endInlineLogging();    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ProbeFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<N>> {

            public N and();
            public N endLivenessProbe();    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ProbeFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<N>> {

            public N and();
            public N endReadinessProbe();    }


      
  /**
   * Representation of a template for Kafka Bridge resources.
   */
  public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


      
  /**
   * Configures the tracing using the Jaeger OpenTracing implementation
   */
  public interface JaegerTracingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.tracing.JaegerTracingFluent<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JaegerTracingNested<N>> {

            public N and();
            public N endJaegerTracing();    }


}
