package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplate;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder;
import java.lang.Object;
import io.strimzi.api.kafka.model.tracing.Tracing;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256FluentImpl;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluentImpl;

public class KafkaBridgeSpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaBridgeSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluentImpl<A> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent<A> {

    private int replicas;
    private java.lang.String image;
    private io.strimzi.api.kafka.model.KafkaBridgeHttpConfigBuilder http;
    private java.lang.String bootstrapServers;
    private io.strimzi.api.kafka.model.ClientTlsBuilder tls;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication,?> authentication;
    private io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecBuilder consumer;
    private io.strimzi.api.kafka.model.KafkaBridgeProducerSpecBuilder producer;
    private io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecBuilder adminClient;
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    private io.strimzi.api.kafka.model.JvmOptionsBuilder jvmOptions;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.Logging,?> logging;
    private boolean enableMetrics;
    private io.strimzi.api.kafka.model.ProbeBuilder livenessProbe;
    private io.strimzi.api.kafka.model.ProbeBuilder readinessProbe;
    private io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder template;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.tracing.Tracing,?> tracing;

    public KafkaBridgeSpecFluentImpl() {
    }

    public KafkaBridgeSpecFluentImpl(io.strimzi.api.kafka.model.KafkaBridgeSpec instance) {
        this.withReplicas(instance.getReplicas());
        
        this.withImage(instance.getImage());
        
        this.withHttp(instance.getHttp());
        
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
        
        this.withConsumer(instance.getConsumer());
        
        this.withProducer(instance.getProducer());
        
        this.withAdminClient(instance.getAdminClient());
        
        this.withResources(instance.getResources());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withLogging(instance.getLogging());
        
        this.withEnableMetrics(instance.getEnableMetrics());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withTemplate(instance.getTemplate());
        
        this.withTracing(instance.getTracing());
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return true;
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original) {
        return (A)withImage(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildHttp instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaBridgeHttpConfig getHttp() {
        return this.http!=null?this.http.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeHttpConfig buildHttp() {
        return this.http!=null?this.http.build():null;
    }

    public A withHttp(io.strimzi.api.kafka.model.KafkaBridgeHttpConfig http) {
        _visitables.get("http").remove(this.http);
        if (http!=null){ this.http= new io.strimzi.api.kafka.model.KafkaBridgeHttpConfigBuilder(http); _visitables.get("http").add(this.http);} return (A) this;
    }

    public java.lang.Boolean hasHttp() {
        return this.http != null;
    }

    public A withNewHttp(int port) {
        return (A)withHttp(new KafkaBridgeHttpConfig(port));
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> withNewHttp() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.HttpNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> withNewHttpLike(io.strimzi.api.kafka.model.KafkaBridgeHttpConfig item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.HttpNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> editHttp() {
        return withNewHttpLike(getHttp());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttp() {
        return withNewHttpLike(getHttp() != null ? getHttp(): new io.strimzi.api.kafka.model.KafkaBridgeHttpConfigBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttpLike(io.strimzi.api.kafka.model.KafkaBridgeHttpConfig item) {
        return withNewHttpLike(getHttp() != null ? getHttp(): item);
    }

    public java.lang.String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public A withBootstrapServers(java.lang.String bootstrapServers) {
        this.bootstrapServers=bootstrapServers; return (A) this;
    }

    public java.lang.Boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBootstrapServers instead.
     */
        public A withNewBootstrapServers(java.lang.String original) {
        return (A)withBootstrapServers(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTls instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.ClientTls getTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public io.strimzi.api.kafka.model.ClientTls buildTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public A withTls(io.strimzi.api.kafka.model.ClientTls tls) {
        _visitables.get("tls").remove(this.tls);
        if (tls!=null){ this.tls= new io.strimzi.api.kafka.model.ClientTlsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public java.lang.Boolean hasTls() {
        return this.tls != null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> withNewTls() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.TlsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> withNewTlsLike(io.strimzi.api.kafka.model.ClientTls item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.TlsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> editTls() {
        return withNewTlsLike(getTls());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> editOrNewTls() {
        return withNewTlsLike(getTls() != null ? getTls(): new io.strimzi.api.kafka.model.ClientTlsBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<A> editOrNewTlsLike(io.strimzi.api.kafka.model.ClientTls item) {
        return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuthentication instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication getAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication buildAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public A withAuthentication(io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication authentication) {
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls)authentication); _visitables.get("authentication").add(this.authentication);}
        return (A) this;
    }

    public java.lang.Boolean hasAuthentication() {
        return this.authentication != null;
    }

    public A withKafkaClientAuthenticationScramSha512(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha512!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder(kafkaClientAuthenticationScramSha512); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationScramSha512NestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationScramSha512NestedImpl(item);
    }

    public A withKafkaClientAuthenticationScramSha256(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 kafkaClientAuthenticationScramSha256) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha256!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder(kafkaClientAuthenticationScramSha256); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationScramSha256NestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationScramSha256NestedImpl(item);
    }

    public A withKafkaClientAuthenticationPlain(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationPlain!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder(kafkaClientAuthenticationPlain); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationPlainNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationPlainNestedImpl(item);
    }

    public A withKafkaClientAuthenticationOAuth(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationOAuth!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder(kafkaClientAuthenticationOAuth); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationOAuthNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationOAuthNestedImpl(item);
    }

    public A withKafkaClientAuthenticationTls(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls kafkaClientAuthenticationTls) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationTls!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder(kafkaClientAuthenticationTls); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationTlsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.KafkaClientAuthenticationTlsNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConsumer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec getConsumer() {
        return this.consumer!=null?this.consumer.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec buildConsumer() {
        return this.consumer!=null?this.consumer.build():null;
    }

    public A withConsumer(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec consumer) {
        _visitables.get("consumer").remove(this.consumer);
        if (consumer!=null){ this.consumer= new io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecBuilder(consumer); _visitables.get("consumer").add(this.consumer);} return (A) this;
    }

    public java.lang.Boolean hasConsumer() {
        return this.consumer != null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumer() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.ConsumerNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumerLike(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.ConsumerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> editConsumer() {
        return withNewConsumerLike(getConsumer());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumer() {
        return withNewConsumerLike(getConsumer() != null ? getConsumer(): new io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumerLike(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec item) {
        return withNewConsumerLike(getConsumer() != null ? getConsumer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildProducer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaBridgeProducerSpec getProducer() {
        return this.producer!=null?this.producer.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeProducerSpec buildProducer() {
        return this.producer!=null?this.producer.build():null;
    }

    public A withProducer(io.strimzi.api.kafka.model.KafkaBridgeProducerSpec producer) {
        _visitables.get("producer").remove(this.producer);
        if (producer!=null){ this.producer= new io.strimzi.api.kafka.model.KafkaBridgeProducerSpecBuilder(producer); _visitables.get("producer").add(this.producer);} return (A) this;
    }

    public java.lang.Boolean hasProducer() {
        return this.producer != null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> withNewProducer() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.ProducerNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> withNewProducerLike(io.strimzi.api.kafka.model.KafkaBridgeProducerSpec item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.ProducerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> editProducer() {
        return withNewProducerLike(getProducer());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducer() {
        return withNewProducerLike(getProducer() != null ? getProducer(): new io.strimzi.api.kafka.model.KafkaBridgeProducerSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducerLike(io.strimzi.api.kafka.model.KafkaBridgeProducerSpec item) {
        return withNewProducerLike(getProducer() != null ? getProducer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAdminClient instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec getAdminClient() {
        return this.adminClient!=null?this.adminClient.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec buildAdminClient() {
        return this.adminClient!=null?this.adminClient.build():null;
    }

    public A withAdminClient(io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec adminClient) {
        _visitables.get("adminClient").remove(this.adminClient);
        if (adminClient!=null){ this.adminClient= new io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecBuilder(adminClient); _visitables.get("adminClient").add(this.adminClient);} return (A) this;
    }

    public java.lang.Boolean hasAdminClient() {
        return this.adminClient != null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> withNewAdminClient() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.AdminClientNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> withNewAdminClientLike(io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.AdminClientNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> editAdminClient() {
        return withNewAdminClientLike(getAdminClient());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> editOrNewAdminClient() {
        return withNewAdminClientLike(getAdminClient() != null ? getAdminClient(): new io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<A> editOrNewAdminClientLike(io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec item) {
        return withNewAdminClientLike(getAdminClient() != null ? getAdminClient(): item);
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJvmOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JvmOptions getJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public io.strimzi.api.kafka.model.JvmOptions buildJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(io.strimzi.api.kafka.model.JvmOptions jvmOptions) {
        _visitables.get("jvmOptions").remove(this.jvmOptions);
        if (jvmOptions!=null){ this.jvmOptions= new io.strimzi.api.kafka.model.JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public java.lang.Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.JvmOptionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.JvmOptionsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new io.strimzi.api.kafka.model.JvmOptionsBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Logging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public io.strimzi.api.kafka.model.Logging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(io.strimzi.api.kafka.model.Logging logging) {
        if (logging instanceof io.strimzi.api.kafka.model.ExternalLogging){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder((io.strimzi.api.kafka.model.ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
        if (logging instanceof io.strimzi.api.kafka.model.InlineLogging){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder((io.strimzi.api.kafka.model.InlineLogging)logging); _visitables.get("logging").add(this.logging);}
        return (A) this;
    }

    public java.lang.Boolean hasLogging() {
        return this.logging != null;
    }

    public A withExternalLogging(io.strimzi.api.kafka.model.ExternalLogging externalLogging) {
        _visitables.get("logging").remove(this.logging);
        if (externalLogging!=null){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.ExternalLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(io.strimzi.api.kafka.model.ExternalLogging item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(io.strimzi.api.kafka.model.InlineLogging inlineLogging) {
        _visitables.get("logging").remove(this.logging);
        if (inlineLogging!=null){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.InlineLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(io.strimzi.api.kafka.model.InlineLogging item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.InlineLoggingNestedImpl(item);
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public A withEnableMetrics(boolean enableMetrics) {
        this.enableMetrics=enableMetrics; return (A) this;
    }

    public java.lang.Boolean hasEnableMetrics() {
        return true;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public java.lang.Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.LivenessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.LivenessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public java.lang.Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.ReadinessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.ReadinessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.KafkaBridgeTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTracing instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.tracing.Tracing getTracing() {
        return this.tracing!=null?this.tracing.build():null;
    }

    public io.strimzi.api.kafka.model.tracing.Tracing buildTracing() {
        return this.tracing!=null?this.tracing.build():null;
    }

    public A withTracing(io.strimzi.api.kafka.model.tracing.Tracing tracing) {
        if (tracing instanceof io.strimzi.api.kafka.model.tracing.JaegerTracing){ this.tracing= new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder((io.strimzi.api.kafka.model.tracing.JaegerTracing)tracing); _visitables.get("tracing").add(this.tracing);}
        return (A) this;
    }

    public java.lang.Boolean hasTracing() {
        return this.tracing != null;
    }

    public A withJaegerTracing(io.strimzi.api.kafka.model.tracing.JaegerTracing jaegerTracing) {
        _visitables.get("tracing").remove(this.tracing);
        if (jaegerTracing!=null){ this.tracing= new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder(jaegerTracing); _visitables.get("tracing").add(this.tracing);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracing() {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.JaegerTracingNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(io.strimzi.api.kafka.model.tracing.JaegerTracing item) {
        return new io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl.JaegerTracingNestedImpl(item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeSpecFluentImpl that = (KafkaBridgeSpecFluentImpl) o;
        if (replicas != that.replicas) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (http != null ? !http.equals(that.http) :that.http != null) return false;
        if (bootstrapServers != null ? !bootstrapServers.equals(that.bootstrapServers) :that.bootstrapServers != null) return false;
        if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
        if (authentication != null ? !authentication.equals(that.authentication) :that.authentication != null) return false;
        if (consumer != null ? !consumer.equals(that.consumer) :that.consumer != null) return false;
        if (producer != null ? !producer.equals(that.producer) :that.producer != null) return false;
        if (adminClient != null ? !adminClient.equals(that.adminClient) :that.adminClient != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (enableMetrics != that.enableMetrics) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        if (tracing != null ? !tracing.equals(that.tracing) :that.tracing != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(replicas,  image,  http,  bootstrapServers,  tls,  authentication,  consumer,  producer,  adminClient,  resources,  jvmOptions,  logging,  enableMetrics,  livenessProbe,  readinessProbe,  template,  tracing,  super.hashCode());
    }

      
  /**
   * A representation of the HTTP configuration.
   */
  public class HttpNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.HttpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaBridgeHttpConfigBuilder builder;

            HttpNestedImpl(io.strimzi.api.kafka.model.KafkaBridgeHttpConfig item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaBridgeHttpConfigBuilder(this, item);
                        
            }

            HttpNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaBridgeHttpConfigBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withHttp(builder.build());
            }

            public N endHttp() {
                return and();
            }
    }


      
  /**
   * Represent the TLS configuration for all the Clients(KafkaConnect, KafkaBridge, KafkaMirrorMaker, KafkaMirrorMaker2).
   */
  public class TlsNestedImpl<N> extends io.strimzi.api.kafka.model.ClientTlsFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ClientTlsBuilder builder;

            TlsNestedImpl(io.strimzi.api.kafka.model.ClientTls item) {
                this.builder = new io.strimzi.api.kafka.model.ClientTlsBuilder(this, item);
                        
            }

            TlsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ClientTlsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withTls(builder.build());
            }

            public N endTls() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_512 in client based components
   */
  public class KafkaClientAuthenticationScramSha512NestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder builder;

            KafkaClientAuthenticationScramSha512NestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder(this, item);
                        
            }

            KafkaClientAuthenticationScramSha512NestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationScramSha512() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_256 in client based components
   */
  public class KafkaClientAuthenticationScramSha256NestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256FluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha256Nested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha256Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder builder;

            KafkaClientAuthenticationScramSha256NestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder(this, item);
                        
            }

            KafkaClientAuthenticationScramSha256NestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationScramSha256() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using SASL PLAIN in client based components
   */
  public class KafkaClientAuthenticationPlainNestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder builder;

            KafkaClientAuthenticationPlainNestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder(this, item);
                        
            }

            KafkaClientAuthenticationPlainNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationPlain() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using SASl OAUTHBEARER mechanism in client based components
   */
  public class KafkaClientAuthenticationOAuthNestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder builder;

            KafkaClientAuthenticationOAuthNestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder(this, item);
                        
            }

            KafkaClientAuthenticationOAuthNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationOAuth() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using TLS client authentication in client based components
   */
  public class KafkaClientAuthenticationTlsNestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder builder;

            KafkaClientAuthenticationTlsNestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder(this, item);
                        
            }

            KafkaClientAuthenticationTlsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationTls() {
                return and();
            }
    }


    public class ConsumerNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ConsumerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecBuilder builder;

            ConsumerNestedImpl(io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecBuilder(this, item);
                        
            }

            ConsumerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withConsumer(builder.build());
            }

            public N endConsumer() {
                return and();
            }
    }


    public class ProducerNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaBridgeProducerSpecFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ProducerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaBridgeProducerSpecBuilder builder;

            ProducerNestedImpl(io.strimzi.api.kafka.model.KafkaBridgeProducerSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaBridgeProducerSpecBuilder(this, item);
                        
            }

            ProducerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaBridgeProducerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withProducer(builder.build());
            }

            public N endProducer() {
                return and();
            }
    }


    public class AdminClientNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.AdminClientNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecBuilder builder;

            AdminClientNestedImpl(io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecBuilder(this, item);
                        
            }

            AdminClientNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withAdminClient(builder.build());
            }

            public N endAdminClient() {
                return and();
            }
    }


      
  /**
   * Representation for options to be passed to a JVM.
   */
  public class JvmOptionsNestedImpl<N> extends io.strimzi.api.kafka.model.JvmOptionsFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JvmOptionsBuilder builder;

            JvmOptionsNestedImpl(io.strimzi.api.kafka.model.JvmOptions item) {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this, item);
                        
            }

            JvmOptionsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withJvmOptions(builder.build());
            }

            public N endJvmOptions() {
                return and();
            }
    }


      
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public class ExternalLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.ExternalLoggingFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ExternalLoggingNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ExternalLoggingBuilder builder;

            ExternalLoggingNestedImpl(io.strimzi.api.kafka.model.ExternalLogging item) {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this, item);
                        
            }

            ExternalLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endExternalLogging() {
                return and();
            }
    }


      
  /**
   * Logging config is given inline with the resource
   */
  public class InlineLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.InlineLoggingFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.InlineLoggingNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.InlineLoggingBuilder builder;

            InlineLoggingNestedImpl(io.strimzi.api.kafka.model.InlineLogging item) {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this, item);
                        
            }

            InlineLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endInlineLogging() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class LivenessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            LivenessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ReadinessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            ReadinessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Kafka Bridge resources.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


      
  /**
   * Configures the tracing using the Jaeger OpenTracing implementation
   */
  public class JaegerTracingNestedImpl<N> extends io.strimzi.api.kafka.model.tracing.JaegerTracingFluentImpl<io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JaegerTracingNested<N>> implements io.strimzi.api.kafka.model.KafkaBridgeSpecFluent.JaegerTracingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder builder;

            JaegerTracingNestedImpl(io.strimzi.api.kafka.model.tracing.JaegerTracing item) {
                this.builder = new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder(this, item);
                        
            }

            JaegerTracingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeSpecFluentImpl.this.withTracing(builder.build());
            }

            public N endJaegerTracing() {
                return and();
            }
    }


}
