package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBuilder extends io.strimzi.api.kafka.model.KafkaFluentImpl<io.strimzi.api.kafka.model.KafkaBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.Kafka,io.strimzi.api.kafka.model.KafkaBuilder> {

    io.strimzi.api.kafka.model.KafkaFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaBuilder() {
        this(true);
    }

    public KafkaBuilder(java.lang.Boolean validationEnabled) {
        this(new Kafka(), validationEnabled);
    }

    public KafkaBuilder(io.strimzi.api.kafka.model.KafkaFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBuilder(io.strimzi.api.kafka.model.KafkaFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Kafka(), validationEnabled);
    }

    public KafkaBuilder(io.strimzi.api.kafka.model.KafkaFluent<?> fluent,io.strimzi.api.kafka.model.Kafka instance) {
        this(fluent, instance, true);
    }

    public KafkaBuilder(io.strimzi.api.kafka.model.KafkaFluent<?> fluent,io.strimzi.api.kafka.model.Kafka instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withKind(instance.getKind());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBuilder(io.strimzi.api.kafka.model.Kafka instance) {
        this(instance,true);
    }

    public KafkaBuilder(io.strimzi.api.kafka.model.Kafka instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.Kafka build() {
        Kafka buildable = new Kafka();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBuilder that = (KafkaBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
