package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.JbodStorageBuilder;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplate;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.storage.Storage;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent;
import java.util.Collection;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.storage.JbodStorageFluent;
import java.util.Iterator;

  
  /**
   * Representation of a Strimzi-managed Kafka "cluster".
   */
  public interface KafkaClusterSpecFluent<A extends io.strimzi.api.kafka.model.KafkaClusterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStorage instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.storage.Storage getStorage();
    public io.strimzi.api.kafka.model.storage.Storage buildStorage();
    public A withStorage(io.strimzi.api.kafka.model.storage.Storage storage);
    public java.lang.Boolean hasStorage();
    public A withPersistentClaimStorage(io.strimzi.api.kafka.model.storage.PersistentClaimStorage persistentClaimStorage);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorage();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(io.strimzi.api.kafka.model.storage.PersistentClaimStorage item);
    public A withEphemeralStorage(io.strimzi.api.kafka.model.storage.EphemeralStorage ephemeralStorage);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorage();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorageLike(io.strimzi.api.kafka.model.storage.EphemeralStorage item);
    public A withJbodStorage(io.strimzi.api.kafka.model.storage.JbodStorage jbodStorage);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JbodStorageNested<A> withNewJbodStorage();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JbodStorageNested<A> withNewJbodStorageLike(io.strimzi.api.kafka.model.storage.JbodStorage item);
    public java.lang.String getVersion();
    public A withVersion(java.lang.String version);
    public java.lang.Boolean hasVersion();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVersion instead.
     */
        public A withNewVersion(java.lang.String original);
    public A addToConfig(java.lang.String key,java.lang.Object value);
    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public A removeFromConfig(java.lang.String key);
    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public java.util.Map<java.lang.String,java.lang.Object> getConfig();
    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config);
    public java.lang.Boolean hasConfig();
    public java.lang.String getBrokerRackInitImage();
    public A withBrokerRackInitImage(java.lang.String brokerRackInitImage);
    public java.lang.Boolean hasBrokerRackInitImage();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBrokerRackInitImage instead.
     */
        public A withNewBrokerRackInitImage(java.lang.String original);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRack instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Rack getRack();
    public io.strimzi.api.kafka.model.Rack buildRack();
    public A withRack(io.strimzi.api.kafka.model.Rack rack);
    public java.lang.Boolean hasRack();
    public A withNewRack(java.lang.String topologyKey);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> withNewRack();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> withNewRackLike(io.strimzi.api.kafka.model.Rack item);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> editRack();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> editOrNewRack();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> editOrNewRackLike(io.strimzi.api.kafka.model.Rack item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Logging getLogging();
    public io.strimzi.api.kafka.model.Logging buildLogging();
    public A withLogging(io.strimzi.api.kafka.model.Logging logging);
    public java.lang.Boolean hasLogging();
    public A withExternalLogging(io.strimzi.api.kafka.model.ExternalLogging externalLogging);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLogging();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(io.strimzi.api.kafka.model.ExternalLogging item);
    public A withInlineLogging(io.strimzi.api.kafka.model.InlineLogging inlineLogging);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.InlineLoggingNested<A> withNewInlineLogging();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(io.strimzi.api.kafka.model.InlineLogging item);
    public int getReplicas();
    public A withReplicas(int replicas);
    public java.lang.Boolean hasReplicas();
    public java.lang.String getImage();
    public A withImage(java.lang.String image);
    public java.lang.Boolean hasImage();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original);
    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources();
    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources);
    public java.lang.Boolean hasResources();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe();
    public io.strimzi.api.kafka.model.Probe buildLivenessProbe();
    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe);
    public java.lang.Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe();
    public io.strimzi.api.kafka.model.Probe buildReadinessProbe();
    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe);
    public java.lang.Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJvmOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JvmOptions getJvmOptions();
    public io.strimzi.api.kafka.model.JvmOptions buildJvmOptions();
    public A withJvmOptions(io.strimzi.api.kafka.model.JvmOptions jvmOptions);
    public java.lang.Boolean hasJvmOptions();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptions();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> editJvmOptions();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaJmxOptions getJmxOptions();
    public io.strimzi.api.kafka.model.KafkaJmxOptions buildJmxOptions();
    public A withJmxOptions(io.strimzi.api.kafka.model.KafkaJmxOptions jmxOptions);
    public java.lang.Boolean hasJmxOptions();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptions();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> editJmxOptions();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptions();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetricsConfig instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.MetricsConfig getMetricsConfig();
    public io.strimzi.api.kafka.model.MetricsConfig buildMetricsConfig();
    public A withMetricsConfig(io.strimzi.api.kafka.model.MetricsConfig metricsConfig);
    public java.lang.Boolean hasMetricsConfig();
    public A withJmxPrometheusExporterMetricsConfig(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item);
    public A addToListeners(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item);
    public A setToListeners(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item);
    public A addToListeners(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener... items);
    public A addAllToListeners(java.util.Collection<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> items);
    public A removeFromListeners(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener... items);
    public A removeAllFromListeners(java.util.Collection<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> items);
    public A removeMatchingFromListeners(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildListeners instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> getListeners();
    public java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> buildListeners();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener buildListener(int index);
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener buildFirstListener();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener buildLastListener();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener buildMatchingListener(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> predicate);
    public java.lang.Boolean hasMatchingListener(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> predicate);
    public A withListeners(java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> listeners);
    public A withListeners(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener... listeners);
    public java.lang.Boolean hasListeners();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> addNewListener();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> addNewListenerLike(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> setNewListenerLike(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> editListener(int index);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> editFirstListener();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> editLastListener();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> editMatchingListener(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuthorization instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaAuthorization getAuthorization();
    public io.strimzi.api.kafka.model.KafkaAuthorization buildAuthorization();
    public A withAuthorization(io.strimzi.api.kafka.model.KafkaAuthorization authorization);
    public java.lang.Boolean hasAuthorization();
    public A withKafkaAuthorizationOpa(io.strimzi.api.kafka.model.KafkaAuthorizationOpa kafkaAuthorizationOpa);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpa();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpaLike(io.strimzi.api.kafka.model.KafkaAuthorizationOpa item);
    public A withKafkaAuthorizationCustom(io.strimzi.api.kafka.model.KafkaAuthorizationCustom kafkaAuthorizationCustom);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationCustomNested<A> withNewKafkaAuthorizationCustom();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationCustomNested<A> withNewKafkaAuthorizationCustomLike(io.strimzi.api.kafka.model.KafkaAuthorizationCustom item);
    public A withKafkaAuthorizationKeycloak(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak kafkaAuthorizationKeycloak);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloak();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloakLike(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak item);
    public A withKafkaAuthorizationSimple(io.strimzi.api.kafka.model.KafkaAuthorizationSimple kafkaAuthorizationSimple);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimple();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimpleLike(io.strimzi.api.kafka.model.KafkaAuthorizationSimple item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.KafkaClusterTemplate getTemplate();
    public io.strimzi.api.kafka.model.template.KafkaClusterTemplate buildTemplate();
    public A withTemplate(io.strimzi.api.kafka.model.template.KafkaClusterTemplate template);
    public java.lang.Boolean hasTemplate();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> withNewTemplate();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaClusterTemplate item);
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> editTemplate();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaClusterTemplate item);
      
  /**
   * Representation for persistent claim-based storage.
   */
  public interface PersistentClaimStorageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.PersistentClaimStorageNested<N>> {

            public N and();
            public N endPersistentClaimStorage();    }


      
  /**
   * Representation for ephemeral storage.
   */
  public interface EphemeralStorageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.storage.EphemeralStorageFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.EphemeralStorageNested<N>> {

            public N and();
            public N endEphemeralStorage();    }


      
  /**
   * Representation for JBOD storage.
   */
  public interface JbodStorageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.storage.JbodStorageFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JbodStorageNested<N>> {

            public N and();
            public N endJbodStorage();    }


      
  /**
   * Representation of the rack configuration.
   */
  public interface RackNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.RackFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<N>> {

            public N and();
            public N endRack();    }


      
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public interface ExternalLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ExternalLoggingFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ExternalLoggingNested<N>> {

            public N and();
            public N endExternalLogging();    }


      
  /**
   * Logging config is given inline with the resource
   */
  public interface InlineLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.InlineLoggingFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.InlineLoggingNested<N>> {

            public N and();
            public N endInlineLogging();    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ProbeFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<N>> {

            public N and();
            public N endLivenessProbe();    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ProbeFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<N>> {

            public N and();
            public N endReadinessProbe();    }


      
  /**
   * Representation for options to be passed to a JVM.
   */
  public interface JvmOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.JvmOptionsFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<N>> {

            public N and();
            public N endJvmOptions();    }


    public interface JmxOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaJmxOptionsFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<N>> {

            public N and();
            public N endJmxOptions();    }


      
  /**
   * JMX Prometheus Exporter metrics config
   */
  public interface JmxPrometheusExporterMetricsConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> {

            public N and();
            public N endJmxPrometheusExporterMetricsConfig();    }


      
  /**
   * Configures the external listener which exposes Kafka outside of Kubernetes / OpenShift
   */
  public interface ListenersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<N>> {

            public N and();
            public N endListener();    }


      
  /**
   * Configures the broker authorization to use Open Policy Agent as an authorization and policy server.
   */
  public interface KafkaAuthorizationOpaNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<N>> {

            public N and();
            public N endKafkaAuthorizationOpa();    }


      
  /**
   * Configures the broker for custom authorization module
   */
  public interface KafkaAuthorizationCustomNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationCustomNested<N>> {

            public N and();
            public N endKafkaAuthorizationCustom();    }


      
  /**
   * Configures Keycloak authorization on the brokers
   */
  public interface KafkaAuthorizationKeycloakNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<N>> {

            public N and();
            public N endKafkaAuthorizationKeycloak();    }


      
  /**
   * Configures the broker authorization
   */
  public interface KafkaAuthorizationSimpleNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaAuthorizationSimpleFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<N>> {

            public N and();
            public N endKafkaAuthorizationSimple();    }


      
  /**
   * Representation of a template for Kafka cluster resources.
   */
  public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


}
