package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.JbodStorageBuilder;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplate;
import java.util.List;
import io.strimzi.api.kafka.model.storage.Storage;
import java.util.Collection;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import java.util.Iterator;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl;
import io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl;

  
  /**
   * Representation of a Strimzi-managed Kafka "cluster".
   */
  public class KafkaClusterSpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaClusterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent<A> {

    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.Storage,?> storage;
    private java.lang.String version;
    private java.util.Map<java.lang.String,java.lang.Object> config;
    private java.lang.String brokerRackInitImage;
    private io.strimzi.api.kafka.model.RackBuilder rack;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.Logging,?> logging;
    private int replicas;
    private java.lang.String image;
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    private io.strimzi.api.kafka.model.ProbeBuilder livenessProbe;
    private io.strimzi.api.kafka.model.ProbeBuilder readinessProbe;
    private io.strimzi.api.kafka.model.JvmOptionsBuilder jvmOptions;
    private io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder jmxOptions;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.MetricsConfig,?> metricsConfig;
    private java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> listeners;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.KafkaAuthorization,?> authorization;
    private io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder template;

    public KafkaClusterSpecFluentImpl() {
    }

    public KafkaClusterSpecFluentImpl(io.strimzi.api.kafka.model.KafkaClusterSpec instance) {
        this.withStorage(instance.getStorage());
        
        this.withVersion(instance.getVersion());
        
        this.withConfig(instance.getConfig());
        
        this.withBrokerRackInitImage(instance.getBrokerRackInitImage());
        
        this.withRack(instance.getRack());
        
        this.withLogging(instance.getLogging());
        
        this.withReplicas(instance.getReplicas());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withJmxOptions(instance.getJmxOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withListeners(instance.getListeners());
        
        this.withAuthorization(instance.getAuthorization());
        
        this.withTemplate(instance.getTemplate());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStorage instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.storage.Storage getStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public io.strimzi.api.kafka.model.storage.Storage buildStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public A withStorage(io.strimzi.api.kafka.model.storage.Storage storage) {
        if (storage instanceof io.strimzi.api.kafka.model.storage.PersistentClaimStorage){ this.storage= new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder((io.strimzi.api.kafka.model.storage.PersistentClaimStorage)storage); _visitables.get("storage").add(this.storage);}
        if (storage instanceof io.strimzi.api.kafka.model.storage.EphemeralStorage){ this.storage= new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder((io.strimzi.api.kafka.model.storage.EphemeralStorage)storage); _visitables.get("storage").add(this.storage);}
        if (storage instanceof io.strimzi.api.kafka.model.storage.JbodStorage){ this.storage= new io.strimzi.api.kafka.model.storage.JbodStorageBuilder((io.strimzi.api.kafka.model.storage.JbodStorage)storage); _visitables.get("storage").add(this.storage);}
        return (A) this;
    }

    public java.lang.Boolean hasStorage() {
        return this.storage != null;
    }

    public A withPersistentClaimStorage(io.strimzi.api.kafka.model.storage.PersistentClaimStorage persistentClaimStorage) {
        _visitables.get("storage").remove(this.storage);
        if (persistentClaimStorage!=null){ this.storage= new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(persistentClaimStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.PersistentClaimStorageNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(io.strimzi.api.kafka.model.storage.PersistentClaimStorage item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.PersistentClaimStorageNestedImpl(item);
    }

    public A withEphemeralStorage(io.strimzi.api.kafka.model.storage.EphemeralStorage ephemeralStorage) {
        _visitables.get("storage").remove(this.storage);
        if (ephemeralStorage!=null){ this.storage= new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(ephemeralStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorage() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.EphemeralStorageNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorageLike(io.strimzi.api.kafka.model.storage.EphemeralStorage item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.EphemeralStorageNestedImpl(item);
    }

    public A withJbodStorage(io.strimzi.api.kafka.model.storage.JbodStorage jbodStorage) {
        _visitables.get("storage").remove(this.storage);
        if (jbodStorage!=null){ this.storage= new io.strimzi.api.kafka.model.storage.JbodStorageBuilder(jbodStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JbodStorageNested<A> withNewJbodStorage() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.JbodStorageNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JbodStorageNested<A> withNewJbodStorageLike(io.strimzi.api.kafka.model.storage.JbodStorage item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.JbodStorageNestedImpl(item);
    }

    public java.lang.String getVersion() {
        return this.version;
    }

    public A withVersion(java.lang.String version) {
        this.version=version; return (A) this;
    }

    public java.lang.Boolean hasVersion() {
        return this.version != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVersion instead.
     */
        public A withNewVersion(java.lang.String original) {
        return (A)withVersion(new String(original));
    }

    public A addToConfig(java.lang.String key,java.lang.Object value) {
        if(this.config == null && key != null && value != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null && map != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(java.lang.String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getConfig() {
        return this.config;
    }

    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(config);} return (A) this;
    }

    public java.lang.Boolean hasConfig() {
        return this.config != null;
    }

    public java.lang.String getBrokerRackInitImage() {
        return this.brokerRackInitImage;
    }

    public A withBrokerRackInitImage(java.lang.String brokerRackInitImage) {
        this.brokerRackInitImage=brokerRackInitImage; return (A) this;
    }

    public java.lang.Boolean hasBrokerRackInitImage() {
        return this.brokerRackInitImage != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBrokerRackInitImage instead.
     */
        public A withNewBrokerRackInitImage(java.lang.String original) {
        return (A)withBrokerRackInitImage(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRack instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Rack getRack() {
        return this.rack!=null?this.rack.build():null;
    }

    public io.strimzi.api.kafka.model.Rack buildRack() {
        return this.rack!=null?this.rack.build():null;
    }

    public A withRack(io.strimzi.api.kafka.model.Rack rack) {
        _visitables.get("rack").remove(this.rack);
        if (rack!=null){ this.rack= new io.strimzi.api.kafka.model.RackBuilder(rack); _visitables.get("rack").add(this.rack);} return (A) this;
    }

    public java.lang.Boolean hasRack() {
        return this.rack != null;
    }

    public A withNewRack(java.lang.String topologyKey) {
        return (A)withRack(new Rack(topologyKey));
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> withNewRack() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.RackNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> withNewRackLike(io.strimzi.api.kafka.model.Rack item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.RackNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> editRack() {
        return withNewRackLike(getRack());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> editOrNewRack() {
        return withNewRackLike(getRack() != null ? getRack(): new io.strimzi.api.kafka.model.RackBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<A> editOrNewRackLike(io.strimzi.api.kafka.model.Rack item) {
        return withNewRackLike(getRack() != null ? getRack(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Logging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public io.strimzi.api.kafka.model.Logging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(io.strimzi.api.kafka.model.Logging logging) {
        if (logging instanceof io.strimzi.api.kafka.model.ExternalLogging){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder((io.strimzi.api.kafka.model.ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
        if (logging instanceof io.strimzi.api.kafka.model.InlineLogging){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder((io.strimzi.api.kafka.model.InlineLogging)logging); _visitables.get("logging").add(this.logging);}
        return (A) this;
    }

    public java.lang.Boolean hasLogging() {
        return this.logging != null;
    }

    public A withExternalLogging(io.strimzi.api.kafka.model.ExternalLogging externalLogging) {
        _visitables.get("logging").remove(this.logging);
        if (externalLogging!=null){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.ExternalLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(io.strimzi.api.kafka.model.ExternalLogging item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(io.strimzi.api.kafka.model.InlineLogging inlineLogging) {
        _visitables.get("logging").remove(this.logging);
        if (inlineLogging!=null){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.InlineLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(io.strimzi.api.kafka.model.InlineLogging item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.InlineLoggingNestedImpl(item);
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return true;
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original) {
        return (A)withImage(new String(original));
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public java.lang.Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.LivenessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.LivenessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public java.lang.Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.ReadinessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.ReadinessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJvmOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JvmOptions getJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public io.strimzi.api.kafka.model.JvmOptions buildJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(io.strimzi.api.kafka.model.JvmOptions jvmOptions) {
        _visitables.get("jvmOptions").remove(this.jvmOptions);
        if (jvmOptions!=null){ this.jvmOptions= new io.strimzi.api.kafka.model.JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public java.lang.Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.JvmOptionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.JvmOptionsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new io.strimzi.api.kafka.model.JvmOptionsBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaJmxOptions getJmxOptions() {
        return this.jmxOptions!=null?this.jmxOptions.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaJmxOptions buildJmxOptions() {
        return this.jmxOptions!=null?this.jmxOptions.build():null;
    }

    public A withJmxOptions(io.strimzi.api.kafka.model.KafkaJmxOptions jmxOptions) {
        _visitables.get("jmxOptions").remove(this.jmxOptions);
        if (jmxOptions!=null){ this.jmxOptions= new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder(jmxOptions); _visitables.get("jmxOptions").add(this.jmxOptions);} return (A) this;
    }

    public java.lang.Boolean hasJmxOptions() {
        return this.jmxOptions != null;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptions() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.JmxOptionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.JmxOptionsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> editJmxOptions() {
        return withNewJmxOptionsLike(getJmxOptions());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptions() {
        return withNewJmxOptionsLike(getJmxOptions() != null ? getJmxOptions(): new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item) {
        return withNewJmxOptionsLike(getJmxOptions() != null ? getJmxOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetricsConfig instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.MetricsConfig getMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public io.strimzi.api.kafka.model.MetricsConfig buildMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public A withMetricsConfig(io.strimzi.api.kafka.model.MetricsConfig metricsConfig) {
        if (metricsConfig instanceof io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder((io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics)metricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);}
        return (A) this;
    }

    public java.lang.Boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public A withJmxPrometheusExporterMetricsConfig(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig) {
        _visitables.get("metricsConfig").remove(this.metricsConfig);
        if (jmxPrometheusExporterMetricsConfig!=null){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    public A addToListeners(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item) {
        if (this.listeners == null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder>();}
        io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder(item);_visitables.get("listeners").add(index >= 0 ? index : _visitables.get("listeners").size(), builder);this.listeners.add(index >= 0 ? index : listeners.size(), builder); return (A)this;
    }

    public A setToListeners(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item) {
        if (this.listeners == null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder>();}
        io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder(item);
        if (index < 0 || index >= _visitables.get("listeners").size()) { _visitables.get("listeners").add(builder); } else { _visitables.get("listeners").set(index, builder);}
        if (index < 0 || index >= listeners.size()) { listeners.add(builder); } else { listeners.set(index, builder);}
         return (A)this;
    }

    public A addToListeners(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener... items) {
        if (this.listeners == null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder>();}
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item : items) {io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
    }

    public A addAllToListeners(java.util.Collection<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> items) {
        if (this.listeners == null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder>();}
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item : items) {io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
    }

    public A removeFromListeners(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener... items) {
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item : items) {io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder(item);_visitables.get("listeners").remove(builder);if (this.listeners != null) {this.listeners.remove(builder);}} return (A)this;
    }

    public A removeAllFromListeners(java.util.Collection<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> items) {
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item : items) {io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder(item);_visitables.get("listeners").remove(builder);if (this.listeners != null) {this.listeners.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromListeners(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> predicate) {
        if (listeners == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> each = listeners.iterator();
        final List visitables = _visitables.get("listeners");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildListeners instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> getListeners() {
        return build(listeners);
    }

    public java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> buildListeners() {
        return build(listeners);
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener buildListener(int index) {
        return this.listeners.get(index).build();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener buildFirstListener() {
        return this.listeners.get(0).build();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener buildLastListener() {
        return this.listeners.get(listeners.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener buildMatchingListener(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> predicate) {
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder item: listeners) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingListener(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> predicate) {
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder item: listeners) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withListeners(java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener> listeners) {
        if (this.listeners != null) { _visitables.get("listeners").removeAll(this.listeners);}
        if (listeners != null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder>(); for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item : listeners){this.addToListeners(item);}} else { this.listeners = null;} return (A) this;
    }

    public A withListeners(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener... listeners) {
        if (this.listeners != null) {this.listeners.clear();}
        if (listeners != null) {for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item :listeners){ this.addToListeners(item);}} return (A) this;
    }

    public java.lang.Boolean hasListeners() {
        return listeners != null && !listeners.isEmpty();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> addNewListener() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.ListenersNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> addNewListenerLike(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.ListenersNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> setNewListenerLike(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.ListenersNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> editListener(int index) {
        if (listeners.size() <= index) throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        return setNewListenerLike(index, buildListener(index));
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> editFirstListener() {
        if (listeners.size() == 0) throw new RuntimeException("Can't edit first listeners. The list is empty.");
        return setNewListenerLike(0, buildListener(0));
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> editLastListener() {
        int index = listeners.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last listeners. The list is empty.");
        return setNewListenerLike(index, buildListener(index));
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<A> editMatchingListener(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<listeners.size();i++) { 
        if (predicate.test(listeners.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching listeners. No match found.");
        return setNewListenerLike(index, buildListener(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuthorization instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaAuthorization getAuthorization() {
        return this.authorization!=null?this.authorization.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaAuthorization buildAuthorization() {
        return this.authorization!=null?this.authorization.build():null;
    }

    public A withAuthorization(io.strimzi.api.kafka.model.KafkaAuthorization authorization) {
        if (authorization instanceof io.strimzi.api.kafka.model.KafkaAuthorizationOpa){ this.authorization= new io.strimzi.api.kafka.model.KafkaAuthorizationOpaBuilder((io.strimzi.api.kafka.model.KafkaAuthorizationOpa)authorization); _visitables.get("authorization").add(this.authorization);}
        if (authorization instanceof io.strimzi.api.kafka.model.KafkaAuthorizationCustom){ this.authorization= new io.strimzi.api.kafka.model.KafkaAuthorizationCustomBuilder((io.strimzi.api.kafka.model.KafkaAuthorizationCustom)authorization); _visitables.get("authorization").add(this.authorization);}
        if (authorization instanceof io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak){ this.authorization= new io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakBuilder((io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak)authorization); _visitables.get("authorization").add(this.authorization);}
        if (authorization instanceof io.strimzi.api.kafka.model.KafkaAuthorizationSimple){ this.authorization= new io.strimzi.api.kafka.model.KafkaAuthorizationSimpleBuilder((io.strimzi.api.kafka.model.KafkaAuthorizationSimple)authorization); _visitables.get("authorization").add(this.authorization);}
        return (A) this;
    }

    public java.lang.Boolean hasAuthorization() {
        return this.authorization != null;
    }

    public A withKafkaAuthorizationOpa(io.strimzi.api.kafka.model.KafkaAuthorizationOpa kafkaAuthorizationOpa) {
        _visitables.get("authorization").remove(this.authorization);
        if (kafkaAuthorizationOpa!=null){ this.authorization= new io.strimzi.api.kafka.model.KafkaAuthorizationOpaBuilder(kafkaAuthorizationOpa); _visitables.get("authorization").add(this.authorization);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpa() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.KafkaAuthorizationOpaNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpaLike(io.strimzi.api.kafka.model.KafkaAuthorizationOpa item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.KafkaAuthorizationOpaNestedImpl(item);
    }

    public A withKafkaAuthorizationCustom(io.strimzi.api.kafka.model.KafkaAuthorizationCustom kafkaAuthorizationCustom) {
        _visitables.get("authorization").remove(this.authorization);
        if (kafkaAuthorizationCustom!=null){ this.authorization= new io.strimzi.api.kafka.model.KafkaAuthorizationCustomBuilder(kafkaAuthorizationCustom); _visitables.get("authorization").add(this.authorization);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationCustomNested<A> withNewKafkaAuthorizationCustom() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.KafkaAuthorizationCustomNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationCustomNested<A> withNewKafkaAuthorizationCustomLike(io.strimzi.api.kafka.model.KafkaAuthorizationCustom item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.KafkaAuthorizationCustomNestedImpl(item);
    }

    public A withKafkaAuthorizationKeycloak(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak kafkaAuthorizationKeycloak) {
        _visitables.get("authorization").remove(this.authorization);
        if (kafkaAuthorizationKeycloak!=null){ this.authorization= new io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakBuilder(kafkaAuthorizationKeycloak); _visitables.get("authorization").add(this.authorization);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloak() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.KafkaAuthorizationKeycloakNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloakLike(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.KafkaAuthorizationKeycloakNestedImpl(item);
    }

    public A withKafkaAuthorizationSimple(io.strimzi.api.kafka.model.KafkaAuthorizationSimple kafkaAuthorizationSimple) {
        _visitables.get("authorization").remove(this.authorization);
        if (kafkaAuthorizationSimple!=null){ this.authorization= new io.strimzi.api.kafka.model.KafkaAuthorizationSimpleBuilder(kafkaAuthorizationSimple); _visitables.get("authorization").add(this.authorization);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimple() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.KafkaAuthorizationSimpleNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimpleLike(io.strimzi.api.kafka.model.KafkaAuthorizationSimple item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.KafkaAuthorizationSimpleNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.KafkaClusterTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.KafkaClusterTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaClusterTemplate item) {
        return new io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaClusterTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaClusterSpecFluentImpl that = (KafkaClusterSpecFluentImpl) o;
        if (storage != null ? !storage.equals(that.storage) :that.storage != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (brokerRackInitImage != null ? !brokerRackInitImage.equals(that.brokerRackInitImage) :that.brokerRackInitImage != null) return false;
        if (rack != null ? !rack.equals(that.rack) :that.rack != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (replicas != that.replicas) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
        if (jmxOptions != null ? !jmxOptions.equals(that.jmxOptions) :that.jmxOptions != null) return false;
        if (metricsConfig != null ? !metricsConfig.equals(that.metricsConfig) :that.metricsConfig != null) return false;
        if (listeners != null ? !listeners.equals(that.listeners) :that.listeners != null) return false;
        if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(storage,  version,  config,  brokerRackInitImage,  rack,  logging,  replicas,  image,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  jmxOptions,  metricsConfig,  listeners,  authorization,  template,  super.hashCode());
    }

      
  /**
   * Representation for persistent claim-based storage.
   */
  public class PersistentClaimStorageNestedImpl<N> extends io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.PersistentClaimStorageNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.PersistentClaimStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder builder;

            PersistentClaimStorageNestedImpl(io.strimzi.api.kafka.model.storage.PersistentClaimStorage item) {
                this.builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(this, item);
                        
            }

            PersistentClaimStorageNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withStorage(builder.build());
            }

            public N endPersistentClaimStorage() {
                return and();
            }
    }


      
  /**
   * Representation for ephemeral storage.
   */
  public class EphemeralStorageNestedImpl<N> extends io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.EphemeralStorageNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.EphemeralStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder builder;

            EphemeralStorageNestedImpl(io.strimzi.api.kafka.model.storage.EphemeralStorage item) {
                this.builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(this, item);
                        
            }

            EphemeralStorageNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withStorage(builder.build());
            }

            public N endEphemeralStorage() {
                return and();
            }
    }


      
  /**
   * Representation for JBOD storage.
   */
  public class JbodStorageNestedImpl<N> extends io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JbodStorageNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JbodStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.storage.JbodStorageBuilder builder;

            JbodStorageNestedImpl(io.strimzi.api.kafka.model.storage.JbodStorage item) {
                this.builder = new io.strimzi.api.kafka.model.storage.JbodStorageBuilder(this, item);
                        
            }

            JbodStorageNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.storage.JbodStorageBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withStorage(builder.build());
            }

            public N endJbodStorage() {
                return and();
            }
    }


      
  /**
   * Representation of the rack configuration.
   */
  public class RackNestedImpl<N> extends io.strimzi.api.kafka.model.RackFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.RackNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.RackBuilder builder;

            RackNestedImpl(io.strimzi.api.kafka.model.Rack item) {
                this.builder = new io.strimzi.api.kafka.model.RackBuilder(this, item);
                        
            }

            RackNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.RackBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withRack(builder.build());
            }

            public N endRack() {
                return and();
            }
    }


      
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public class ExternalLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.ExternalLoggingFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ExternalLoggingNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ExternalLoggingBuilder builder;

            ExternalLoggingNestedImpl(io.strimzi.api.kafka.model.ExternalLogging item) {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this, item);
                        
            }

            ExternalLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endExternalLogging() {
                return and();
            }
    }


      
  /**
   * Logging config is given inline with the resource
   */
  public class InlineLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.InlineLoggingFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.InlineLoggingNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.InlineLoggingBuilder builder;

            InlineLoggingNestedImpl(io.strimzi.api.kafka.model.InlineLogging item) {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this, item);
                        
            }

            InlineLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endInlineLogging() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class LivenessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            LivenessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ReadinessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            ReadinessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


      
  /**
   * Representation for options to be passed to a JVM.
   */
  public class JvmOptionsNestedImpl<N> extends io.strimzi.api.kafka.model.JvmOptionsFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JvmOptionsBuilder builder;

            JvmOptionsNestedImpl(io.strimzi.api.kafka.model.JvmOptions item) {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this, item);
                        
            }

            JvmOptionsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withJvmOptions(builder.build());
            }

            public N endJvmOptions() {
                return and();
            }
    }


    public class JmxOptionsNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaJmxOptionsFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder builder;

            JmxOptionsNestedImpl(io.strimzi.api.kafka.model.KafkaJmxOptions item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder(this, item);
                        
            }

            JmxOptionsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withJmxOptions(builder.build());
            }

            public N endJmxOptions() {
                return and();
            }
    }


      
  /**
   * JMX Prometheus Exporter metrics config
   */
  public class JmxPrometheusExporterMetricsConfigNestedImpl<N> extends io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder builder;

            JmxPrometheusExporterMetricsConfigNestedImpl(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this, item);
                        
            }

            JmxPrometheusExporterMetricsConfigNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withMetricsConfig(builder.build());
            }

            public N endJmxPrometheusExporterMetricsConfig() {
                return and();
            }
    }


      
  /**
   * Configures the external listener which exposes Kafka outside of Kubernetes / OpenShift
   */
  public class ListenersNestedImpl<N> extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.ListenersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder builder;
        private final int index;

            ListenersNestedImpl(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder(this, item);
                        
            }

            ListenersNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.setToListeners(index,builder.build());
            }

            public N endListener() {
                return and();
            }
    }


      
  /**
   * Configures the broker authorization to use Open Policy Agent as an authorization and policy server.
   */
  public class KafkaAuthorizationOpaNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaAuthorizationOpaBuilder builder;

            KafkaAuthorizationOpaNestedImpl(io.strimzi.api.kafka.model.KafkaAuthorizationOpa item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaAuthorizationOpaBuilder(this, item);
                        
            }

            KafkaAuthorizationOpaNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaAuthorizationOpaBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withAuthorization(builder.build());
            }

            public N endKafkaAuthorizationOpa() {
                return and();
            }
    }


      
  /**
   * Configures the broker for custom authorization module
   */
  public class KafkaAuthorizationCustomNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationCustomNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationCustomNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaAuthorizationCustomBuilder builder;

            KafkaAuthorizationCustomNestedImpl(io.strimzi.api.kafka.model.KafkaAuthorizationCustom item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaAuthorizationCustomBuilder(this, item);
                        
            }

            KafkaAuthorizationCustomNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaAuthorizationCustomBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withAuthorization(builder.build());
            }

            public N endKafkaAuthorizationCustom() {
                return and();
            }
    }


      
  /**
   * Configures Keycloak authorization on the brokers
   */
  public class KafkaAuthorizationKeycloakNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakBuilder builder;

            KafkaAuthorizationKeycloakNestedImpl(io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakBuilder(this, item);
                        
            }

            KafkaAuthorizationKeycloakNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withAuthorization(builder.build());
            }

            public N endKafkaAuthorizationKeycloak() {
                return and();
            }
    }


      
  /**
   * Configures the broker authorization
   */
  public class KafkaAuthorizationSimpleNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaAuthorizationSimpleFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaAuthorizationSimpleBuilder builder;

            KafkaAuthorizationSimpleNestedImpl(io.strimzi.api.kafka.model.KafkaAuthorizationSimple item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaAuthorizationSimpleBuilder(this, item);
                        
            }

            KafkaAuthorizationSimpleNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaAuthorizationSimpleBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withAuthorization(builder.build());
            }

            public N endKafkaAuthorizationSimple() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Kafka cluster resources.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl<io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.KafkaClusterSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.KafkaClusterTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


}
