package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectBuilder extends io.strimzi.api.kafka.model.KafkaConnectFluentImpl<io.strimzi.api.kafka.model.KafkaConnectBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaConnect,io.strimzi.api.kafka.model.KafkaConnectBuilder> {

    io.strimzi.api.kafka.model.KafkaConnectFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaConnectBuilder() {
        this(true);
    }

    public KafkaConnectBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaConnect(), validationEnabled);
    }

    public KafkaConnectBuilder(io.strimzi.api.kafka.model.KafkaConnectFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectBuilder(io.strimzi.api.kafka.model.KafkaConnectFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaConnect(), validationEnabled);
    }

    public KafkaConnectBuilder(io.strimzi.api.kafka.model.KafkaConnectFluent<?> fluent,io.strimzi.api.kafka.model.KafkaConnect instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectBuilder(io.strimzi.api.kafka.model.KafkaConnectFluent<?> fluent,io.strimzi.api.kafka.model.KafkaConnect instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withKind(instance.getKind());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectBuilder(io.strimzi.api.kafka.model.KafkaConnect instance) {
        this(instance,true);
    }

    public KafkaConnectBuilder(io.strimzi.api.kafka.model.KafkaConnect instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withSpec(instance.getSpec());
        
        this.withMetadata(instance.getMetadata());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaConnect build() {
        KafkaConnect buildable = new KafkaConnect();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setSpec(fluent.getSpec());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectBuilder that = (KafkaConnectBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
