package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectSpecBuilder extends io.strimzi.api.kafka.model.KafkaConnectSpecFluentImpl<io.strimzi.api.kafka.model.KafkaConnectSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaConnectSpec,io.strimzi.api.kafka.model.KafkaConnectSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaConnectSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaConnectSpecBuilder() {
        this(true);
    }

    public KafkaConnectSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaConnectSpec(), validationEnabled);
    }

    public KafkaConnectSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaConnectSpec(), validationEnabled);
    }

    public KafkaConnectSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaConnectSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaConnectSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfig(instance.getConfig());
        
        fluent.withClientRackInitImage(instance.getClientRackInitImage());
        
        fluent.withRack(instance.getRack());
        
        fluent.withBootstrapServers(instance.getBootstrapServers());
        
        fluent.withTls(instance.getTls());
        
        fluent.withAuthentication(instance.getAuthentication());
        
        fluent.withBuild(instance.getBuild());
        
        fluent.withLogging(instance.getLogging());
        
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withVersion(instance.getVersion());
        
        fluent.withImage(instance.getImage());
        
        fluent.withResources(instance.getResources());
        
        fluent.withLivenessProbe(instance.getLivenessProbe());
        
        fluent.withReadinessProbe(instance.getReadinessProbe());
        
        fluent.withJmxOptions(instance.getJmxOptions());
        
        fluent.withJvmOptions(instance.getJvmOptions());
        
        fluent.withMetricsConfig(instance.getMetricsConfig());
        
        fluent.withTracing(instance.getTracing());
        
        fluent.withTemplate(instance.getTemplate());
        
        fluent.withExternalConfiguration(instance.getExternalConfiguration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectSpec instance) {
        this(instance,true);
    }

    public KafkaConnectSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfig(instance.getConfig());
        
        this.withClientRackInitImage(instance.getClientRackInitImage());
        
        this.withRack(instance.getRack());
        
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
        
        this.withBuild(instance.getBuild());
        
        this.withLogging(instance.getLogging());
        
        this.withReplicas(instance.getReplicas());
        
        this.withVersion(instance.getVersion());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJmxOptions(instance.getJmxOptions());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withTracing(instance.getTracing());
        
        this.withTemplate(instance.getTemplate());
        
        this.withExternalConfiguration(instance.getExternalConfiguration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaConnectSpec build() {
        KafkaConnectSpec buildable = new KafkaConnectSpec();
        buildable.setLogging(fluent.getLogging());
        buildable.setReplicas(fluent.getReplicas());
        buildable.setVersion(fluent.getVersion());
        buildable.setImage(fluent.getImage());
        buildable.setResources(fluent.getResources());
        buildable.setLivenessProbe(fluent.getLivenessProbe());
        buildable.setReadinessProbe(fluent.getReadinessProbe());
        buildable.setJmxOptions(fluent.getJmxOptions());
        buildable.setJvmOptions(fluent.getJvmOptions());
        buildable.setMetricsConfig(fluent.getMetricsConfig());
        buildable.setTracing(fluent.getTracing());
        buildable.setTemplate(fluent.getTemplate());
        buildable.setExternalConfiguration(fluent.getExternalConfiguration());
        buildable.setConfig(fluent.getConfig());
        buildable.setClientRackInitImage(fluent.getClientRackInitImage());
        buildable.setRack(fluent.getRack());
        buildable.setBootstrapServers(fluent.getBootstrapServers());
        buildable.setTls(fluent.getTls());
        buildable.setAuthentication(fluent.getAuthentication());
        buildable.setBuild(fluent.getBuild());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectSpecBuilder that = (KafkaConnectSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
