package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.connect.build.Build;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.connect.build.BuildFluent;
import io.strimzi.api.kafka.model.connect.build.BuildBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent;

public interface KafkaConnectSpecFluent<A extends io.strimzi.api.kafka.model.KafkaConnectSpecFluent<A>> extends io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent<A> {


    public A addToConfig(java.lang.String key,java.lang.Object value);
    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public A removeFromConfig(java.lang.String key);
    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public java.util.Map<java.lang.String,java.lang.Object> getConfig();
    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config);
    public java.lang.Boolean hasConfig();
    public java.lang.String getClientRackInitImage();
    public A withClientRackInitImage(java.lang.String clientRackInitImage);
    public java.lang.Boolean hasClientRackInitImage();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientRackInitImage instead.
     */
        public A withNewClientRackInitImage(java.lang.String original);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRack instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Rack getRack();
    public io.strimzi.api.kafka.model.Rack buildRack();
    public A withRack(io.strimzi.api.kafka.model.Rack rack);
    public java.lang.Boolean hasRack();
    public A withNewRack(java.lang.String topologyKey);
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.RackNested<A> withNewRack();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.RackNested<A> withNewRackLike(io.strimzi.api.kafka.model.Rack item);
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.RackNested<A> editRack();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.RackNested<A> editOrNewRack();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.RackNested<A> editOrNewRackLike(io.strimzi.api.kafka.model.Rack item);
    public java.lang.String getBootstrapServers();
    public A withBootstrapServers(java.lang.String bootstrapServers);
    public java.lang.Boolean hasBootstrapServers();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBootstrapServers instead.
     */
        public A withNewBootstrapServers(java.lang.String original);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTls instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.ClientTls getTls();
    public io.strimzi.api.kafka.model.ClientTls buildTls();
    public A withTls(io.strimzi.api.kafka.model.ClientTls tls);
    public java.lang.Boolean hasTls();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.TlsNested<A> withNewTls();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.TlsNested<A> withNewTlsLike(io.strimzi.api.kafka.model.ClientTls item);
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.TlsNested<A> editTls();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.TlsNested<A> editOrNewTls();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.TlsNested<A> editOrNewTlsLike(io.strimzi.api.kafka.model.ClientTls item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuthentication instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication getAuthentication();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication buildAuthentication();
    public A withAuthentication(io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication authentication);
    public java.lang.Boolean hasAuthentication();
    public A withKafkaClientAuthenticationScramSha512(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512);
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 item);
    public A withKafkaClientAuthenticationScramSha256(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 kafkaClientAuthenticationScramSha256);
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 item);
    public A withKafkaClientAuthenticationPlain(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain);
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain item);
    public A withKafkaClientAuthenticationOAuth(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth);
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth item);
    public A withKafkaClientAuthenticationTls(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls kafkaClientAuthenticationTls);
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBuild instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.connect.build.Build getBuild();
    public io.strimzi.api.kafka.model.connect.build.Build buildBuild();
    public A withBuild(io.strimzi.api.kafka.model.connect.build.Build build);
    public java.lang.Boolean hasBuild();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.BuildNested<A> withNewBuild();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.BuildNested<A> withNewBuildLike(io.strimzi.api.kafka.model.connect.build.Build item);
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.BuildNested<A> editBuild();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.BuildNested<A> editOrNewBuild();
    public io.strimzi.api.kafka.model.KafkaConnectSpecFluent.BuildNested<A> editOrNewBuildLike(io.strimzi.api.kafka.model.connect.build.Build item);
      
  /**
   * Representation of the rack configuration.
   */
  public interface RackNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.RackFluent<io.strimzi.api.kafka.model.KafkaConnectSpecFluent.RackNested<N>> {

            public N and();
            public N endRack();    }


      
  /**
   * Represent the TLS configuration for all the Clients(KafkaConnect, KafkaBridge, KafkaMirrorMaker, KafkaMirrorMaker2).
   */
  public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ClientTlsFluent<io.strimzi.api.kafka.model.KafkaConnectSpecFluent.TlsNested<N>> {

            public N and();
            public N endTls();    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_512 in client based components
   */
  public interface KafkaClientAuthenticationScramSha512Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>> {

            public N and();
            public N endKafkaClientAuthenticationScramSha512();    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_256 in client based components
   */
  public interface KafkaClientAuthenticationScramSha256Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent<io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha256Nested<N>> {

            public N and();
            public N endKafkaClientAuthenticationScramSha256();    }


      
  /**
   * Configures the Kafka client authentication using SASL PLAIN in client based components
   */
  public interface KafkaClientAuthenticationPlainNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent<io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationPlain();    }


      
  /**
   * Configures the Kafka client authentication using SASl OAUTHBEARER mechanism in client based components
   */
  public interface KafkaClientAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationOAuth();    }


      
  /**
   * Configures the Kafka client authentication using TLS client authentication in client based components
   */
  public interface KafkaClientAuthenticationTlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<io.strimzi.api.kafka.model.KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationTls();    }


      
  /**
   * Representation a Kafka Connect build to add additional connectors
   */
  public interface BuildNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.connect.build.BuildFluent<io.strimzi.api.kafka.model.KafkaConnectSpecFluent.BuildNested<N>> {

            public N and();
            public N endBuild();    }


}
