package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectorBuilder extends io.strimzi.api.kafka.model.KafkaConnectorFluentImpl<io.strimzi.api.kafka.model.KafkaConnectorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaConnector,io.strimzi.api.kafka.model.KafkaConnectorBuilder> {

    io.strimzi.api.kafka.model.KafkaConnectorFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaConnectorBuilder() {
        this(true);
    }

    public KafkaConnectorBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaConnector(), validationEnabled);
    }

    public KafkaConnectorBuilder(io.strimzi.api.kafka.model.KafkaConnectorFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectorBuilder(io.strimzi.api.kafka.model.KafkaConnectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaConnector(), validationEnabled);
    }

    public KafkaConnectorBuilder(io.strimzi.api.kafka.model.KafkaConnectorFluent<?> fluent,io.strimzi.api.kafka.model.KafkaConnector instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectorBuilder(io.strimzi.api.kafka.model.KafkaConnectorFluent<?> fluent,io.strimzi.api.kafka.model.KafkaConnector instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withKind(instance.getKind());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectorBuilder(io.strimzi.api.kafka.model.KafkaConnector instance) {
        this(instance,true);
    }

    public KafkaConnectorBuilder(io.strimzi.api.kafka.model.KafkaConnector instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.withMetadata(instance.getMetadata());
        
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaConnector build() {
        KafkaConnector buildable = new KafkaConnector();
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectorBuilder that = (KafkaConnectorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
