package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluentImpl;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatus;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectorFluentImpl<A extends io.strimzi.api.kafka.model.KafkaConnectorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaConnectorFluent<A> {

    private io.strimzi.api.kafka.model.KafkaConnectorSpecBuilder spec;
    private io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder status;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.lang.String apiVersion;
    private java.lang.String kind;

    public KafkaConnectorFluentImpl() {
    }

    public KafkaConnectorFluentImpl(io.strimzi.api.kafka.model.KafkaConnector instance) {
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.withMetadata(instance.getMetadata());
        
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSpec instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaConnectorSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaConnectorSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(io.strimzi.api.kafka.model.KafkaConnectorSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new io.strimzi.api.kafka.model.KafkaConnectorSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public java.lang.Boolean hasSpec() {
        return this.spec != null;
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.SpecNested<A> withNewSpec() {
        return new io.strimzi.api.kafka.model.KafkaConnectorFluentImpl.SpecNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.SpecNested<A> withNewSpecLike(io.strimzi.api.kafka.model.KafkaConnectorSpec item) {
        return new io.strimzi.api.kafka.model.KafkaConnectorFluentImpl.SpecNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new io.strimzi.api.kafka.model.KafkaConnectorSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.SpecNested<A> editOrNewSpecLike(io.strimzi.api.kafka.model.KafkaConnectorSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStatus instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.status.KafkaConnectorStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public io.strimzi.api.kafka.model.status.KafkaConnectorStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(io.strimzi.api.kafka.model.status.KafkaConnectorStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public java.lang.Boolean hasStatus() {
        return this.status != null;
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.StatusNested<A> withNewStatus() {
        return new io.strimzi.api.kafka.model.KafkaConnectorFluentImpl.StatusNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.StatusNested<A> withNewStatusLike(io.strimzi.api.kafka.model.status.KafkaConnectorStatus item) {
        return new io.strimzi.api.kafka.model.KafkaConnectorFluentImpl.StatusNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.StatusNested<A> editOrNewStatusLike(io.strimzi.api.kafka.model.status.KafkaConnectorStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.MetadataNested<A> withNewMetadata() {
        return new io.strimzi.api.kafka.model.KafkaConnectorFluentImpl.MetadataNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.strimzi.api.kafka.model.KafkaConnectorFluentImpl.MetadataNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaConnectorFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String original) {
        return (A)withApiVersion(new String(original));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String original) {
        return (A)withKind(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaConnectorFluentImpl that = (KafkaConnectorFluentImpl) o;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(spec,  status,  metadata,  apiVersion,  kind,  super.hashCode());
    }

    public class SpecNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaConnectorSpecFluentImpl<io.strimzi.api.kafka.model.KafkaConnectorFluent.SpecNested<N>> implements io.strimzi.api.kafka.model.KafkaConnectorFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaConnectorSpecBuilder builder;

            SpecNestedImpl(io.strimzi.api.kafka.model.KafkaConnectorSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaConnectorSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaConnectorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectorFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


      
  /**
   * Represents a status of the KafkaConnector resource
   */
  public class StatusNestedImpl<N> extends io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluentImpl<io.strimzi.api.kafka.model.KafkaConnectorFluent.StatusNested<N>> implements io.strimzi.api.kafka.model.KafkaConnectorFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder builder;

            StatusNestedImpl(io.strimzi.api.kafka.model.status.KafkaConnectorStatus item) {
                this.builder = new io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectorFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.strimzi.api.kafka.model.KafkaConnectorFluent.MetadataNested<N>> implements io.strimzi.api.kafka.model.KafkaConnectorFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectorFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
