package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectorSpecBuilder extends io.strimzi.api.kafka.model.KafkaConnectorSpecFluentImpl<io.strimzi.api.kafka.model.KafkaConnectorSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaConnectorSpec,io.strimzi.api.kafka.model.KafkaConnectorSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaConnectorSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaConnectorSpecBuilder() {
        this(true);
    }

    public KafkaConnectorSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaConnectorSpec(), validationEnabled);
    }

    public KafkaConnectorSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectorSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectorSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectorSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaConnectorSpec(), validationEnabled);
    }

    public KafkaConnectorSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectorSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaConnectorSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectorSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectorSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaConnectorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClassName(instance.getClassName());
        
        fluent.withTasksMax(instance.getTasksMax());
        
        fluent.withPause(instance.getPause());
        
        fluent.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectorSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectorSpec instance) {
        this(instance,true);
    }

    public KafkaConnectorSpecBuilder(io.strimzi.api.kafka.model.KafkaConnectorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withClassName(instance.getClassName());
        
        this.withTasksMax(instance.getTasksMax());
        
        this.withPause(instance.getPause());
        
        this.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaConnectorSpec build() {
        KafkaConnectorSpec buildable = new KafkaConnectorSpec();
        buildable.setTasksMax(fluent.getTasksMax());
        buildable.setPause(fluent.getPause());
        buildable.setConfig(fluent.getConfig());
        buildable.setClassName(fluent.getClassName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectorSpecBuilder that = (KafkaConnectorSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
