package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.template.KafkaExporterTemplate;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Representation of the Kafka Exporter deployment.
   */
  public interface KafkaExporterSpecFluent<A extends io.strimzi.api.kafka.model.KafkaExporterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getImage();
    public A withImage(java.lang.String image);
    public java.lang.Boolean hasImage();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original);
    public java.lang.String getGroupRegex();
    public A withGroupRegex(java.lang.String groupRegex);
    public java.lang.Boolean hasGroupRegex();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGroupRegex instead.
     */
        public A withNewGroupRegex(java.lang.String original);
    public java.lang.String getTopicRegex();
    public A withTopicRegex(java.lang.String topicRegex);
    public java.lang.Boolean hasTopicRegex();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTopicRegex instead.
     */
        public A withNewTopicRegex(java.lang.String original);
    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources();
    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources);
    public java.lang.Boolean hasResources();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe();
    public io.strimzi.api.kafka.model.Probe buildLivenessProbe();
    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe);
    public java.lang.Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item);
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe();
    public io.strimzi.api.kafka.model.Probe buildReadinessProbe();
    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe);
    public java.lang.Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item);
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item);
    public java.lang.String getLogging();
    public A withLogging(java.lang.String logging);
    public java.lang.Boolean hasLogging();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLogging instead.
     */
        public A withNewLogging(java.lang.String original);
    public boolean isEnableSaramaLogging();
    public A withEnableSaramaLogging(boolean enableSaramaLogging);
    public java.lang.Boolean hasEnableSaramaLogging();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.KafkaExporterTemplate getTemplate();
    public io.strimzi.api.kafka.model.template.KafkaExporterTemplate buildTemplate();
    public A withTemplate(io.strimzi.api.kafka.model.template.KafkaExporterTemplate template);
    public java.lang.Boolean hasTemplate();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> withNewTemplate();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaExporterTemplate item);
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> editTemplate();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaExporterTemplate item);
      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ProbeFluent<io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<N>> {

            public N and();
            public N endLivenessProbe();    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ProbeFluent<io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<N>> {

            public N and();
            public N endReadinessProbe();    }


      
  /**
   * Representation of a template for Kafka Exporter resources.
   */
  public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent<io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


}
