package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.template.KafkaExporterTemplate;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl;
import java.lang.Boolean;

  
  /**
   * Representation of the Kafka Exporter deployment.
   */
  public class KafkaExporterSpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaExporterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaExporterSpecFluent<A> {

    private java.lang.String image;
    private java.lang.String groupRegex;
    private java.lang.String topicRegex;
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    private io.strimzi.api.kafka.model.ProbeBuilder livenessProbe;
    private io.strimzi.api.kafka.model.ProbeBuilder readinessProbe;
    private java.lang.String logging;
    private boolean enableSaramaLogging;
    private io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder template;

    public KafkaExporterSpecFluentImpl() {
    }

    public KafkaExporterSpecFluentImpl(io.strimzi.api.kafka.model.KafkaExporterSpec instance) {
        this.withImage(instance.getImage());
        
        this.withGroupRegex(instance.getGroupRegex());
        
        this.withTopicRegex(instance.getTopicRegex());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withLogging(instance.getLogging());
        
        this.withEnableSaramaLogging(instance.getEnableSaramaLogging());
        
        this.withTemplate(instance.getTemplate());
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original) {
        return (A)withImage(new String(original));
    }

    public java.lang.String getGroupRegex() {
        return this.groupRegex;
    }

    public A withGroupRegex(java.lang.String groupRegex) {
        this.groupRegex=groupRegex; return (A) this;
    }

    public java.lang.Boolean hasGroupRegex() {
        return this.groupRegex != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGroupRegex instead.
     */
        public A withNewGroupRegex(java.lang.String original) {
        return (A)withGroupRegex(new String(original));
    }

    public java.lang.String getTopicRegex() {
        return this.topicRegex;
    }

    public A withTopicRegex(java.lang.String topicRegex) {
        this.topicRegex=topicRegex; return (A) this;
    }

    public java.lang.Boolean hasTopicRegex() {
        return this.topicRegex != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTopicRegex instead.
     */
        public A withNewTopicRegex(java.lang.String original) {
        return (A)withTopicRegex(new String(original));
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public java.lang.Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new io.strimzi.api.kafka.model.KafkaExporterSpecFluentImpl.LivenessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.KafkaExporterSpecFluentImpl.LivenessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public java.lang.Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new io.strimzi.api.kafka.model.KafkaExporterSpecFluentImpl.ReadinessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.KafkaExporterSpecFluentImpl.ReadinessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    public java.lang.String getLogging() {
        return this.logging;
    }

    public A withLogging(java.lang.String logging) {
        this.logging=logging; return (A) this;
    }

    public java.lang.Boolean hasLogging() {
        return this.logging != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLogging instead.
     */
        public A withNewLogging(java.lang.String original) {
        return (A)withLogging(new String(original));
    }

    public boolean isEnableSaramaLogging() {
        return this.enableSaramaLogging;
    }

    public A withEnableSaramaLogging(boolean enableSaramaLogging) {
        this.enableSaramaLogging=enableSaramaLogging; return (A) this;
    }

    public java.lang.Boolean hasEnableSaramaLogging() {
        return true;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.KafkaExporterTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.KafkaExporterTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.KafkaExporterSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaExporterTemplate item) {
        return new io.strimzi.api.kafka.model.KafkaExporterSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaExporterTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaExporterSpecFluentImpl that = (KafkaExporterSpecFluentImpl) o;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (groupRegex != null ? !groupRegex.equals(that.groupRegex) :that.groupRegex != null) return false;
        if (topicRegex != null ? !topicRegex.equals(that.topicRegex) :that.topicRegex != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (enableSaramaLogging != that.enableSaramaLogging) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(image,  groupRegex,  topicRegex,  resources,  livenessProbe,  readinessProbe,  logging,  enableSaramaLogging,  template,  super.hashCode());
    }

      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class LivenessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<N>> implements io.strimzi.api.kafka.model.KafkaExporterSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            LivenessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterSpecFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ReadinessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<N>> implements io.strimzi.api.kafka.model.KafkaExporterSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            ReadinessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterSpecFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Kafka Exporter resources.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl<io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.KafkaExporterSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.KafkaExporterTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


}
