package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaJmxOptionsBuilder extends io.strimzi.api.kafka.model.KafkaJmxOptionsFluentImpl<io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaJmxOptions,io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder> {

    io.strimzi.api.kafka.model.KafkaJmxOptionsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaJmxOptionsBuilder() {
        this(true);
    }

    public KafkaJmxOptionsBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaJmxOptions(), validationEnabled);
    }

    public KafkaJmxOptionsBuilder(io.strimzi.api.kafka.model.KafkaJmxOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaJmxOptionsBuilder(io.strimzi.api.kafka.model.KafkaJmxOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaJmxOptions(), validationEnabled);
    }

    public KafkaJmxOptionsBuilder(io.strimzi.api.kafka.model.KafkaJmxOptionsFluent<?> fluent,io.strimzi.api.kafka.model.KafkaJmxOptions instance) {
        this(fluent, instance, true);
    }

    public KafkaJmxOptionsBuilder(io.strimzi.api.kafka.model.KafkaJmxOptionsFluent<?> fluent,io.strimzi.api.kafka.model.KafkaJmxOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaJmxOptionsBuilder(io.strimzi.api.kafka.model.KafkaJmxOptions instance) {
        this(instance,true);
    }

    public KafkaJmxOptionsBuilder(io.strimzi.api.kafka.model.KafkaJmxOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaJmxOptions build() {
        KafkaJmxOptions buildable = new KafkaJmxOptions();
        buildable.setAuthentication(fluent.getAuthentication());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaJmxOptionsBuilder that = (KafkaJmxOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
