package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256FluentImpl;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder;
import java.lang.Object;
import java.util.Map;

public class KafkaMirrorMaker2ClusterSpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent<A> {

    private java.lang.String alias;
    private java.lang.String bootstrapServers;
    private java.util.Map<java.lang.String,java.lang.Object> config;
    private io.strimzi.api.kafka.model.ClientTlsBuilder tls;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication,?> authentication;

    public KafkaMirrorMaker2ClusterSpecFluentImpl() {
    }

    public KafkaMirrorMaker2ClusterSpecFluentImpl(io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec instance) {
        this.withAlias(instance.getAlias());
        
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withConfig(instance.getConfig());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
    }

    public java.lang.String getAlias() {
        return this.alias;
    }

    public A withAlias(java.lang.String alias) {
        this.alias=alias; return (A) this;
    }

    public java.lang.Boolean hasAlias() {
        return this.alias != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAlias instead.
     */
        public A withNewAlias(java.lang.String original) {
        return (A)withAlias(new String(original));
    }

    public java.lang.String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public A withBootstrapServers(java.lang.String bootstrapServers) {
        this.bootstrapServers=bootstrapServers; return (A) this;
    }

    public java.lang.Boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBootstrapServers instead.
     */
        public A withNewBootstrapServers(java.lang.String original) {
        return (A)withBootstrapServers(new String(original));
    }

    public A addToConfig(java.lang.String key,java.lang.Object value) {
        if(this.config == null && key != null && value != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null && map != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(java.lang.String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getConfig() {
        return this.config;
    }

    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(config);} return (A) this;
    }

    public java.lang.Boolean hasConfig() {
        return this.config != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTls instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.ClientTls getTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public io.strimzi.api.kafka.model.ClientTls buildTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public A withTls(io.strimzi.api.kafka.model.ClientTls tls) {
        _visitables.get("tls").remove(this.tls);
        if (tls!=null){ this.tls= new io.strimzi.api.kafka.model.ClientTlsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public java.lang.Boolean hasTls() {
        return this.tls != null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> withNewTls() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.TlsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> withNewTlsLike(io.strimzi.api.kafka.model.ClientTls item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.TlsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> editTls() {
        return withNewTlsLike(getTls());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> editOrNewTls() {
        return withNewTlsLike(getTls() != null ? getTls(): new io.strimzi.api.kafka.model.ClientTlsBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> editOrNewTlsLike(io.strimzi.api.kafka.model.ClientTls item) {
        return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuthentication instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication getAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication buildAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public A withAuthentication(io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication authentication) {
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder((io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls)authentication); _visitables.get("authentication").add(this.authentication);}
        return (A) this;
    }

    public java.lang.Boolean hasAuthentication() {
        return this.authentication != null;
    }

    public A withKafkaClientAuthenticationScramSha512(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha512!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder(kafkaClientAuthenticationScramSha512); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationScramSha512NestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationScramSha512NestedImpl(item);
    }

    public A withKafkaClientAuthenticationScramSha256(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 kafkaClientAuthenticationScramSha256) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha256!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder(kafkaClientAuthenticationScramSha256); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationScramSha256NestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationScramSha256NestedImpl(item);
    }

    public A withKafkaClientAuthenticationPlain(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationPlain!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder(kafkaClientAuthenticationPlain); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationPlainNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationPlainNestedImpl(item);
    }

    public A withKafkaClientAuthenticationOAuth(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationOAuth!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder(kafkaClientAuthenticationOAuth); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationOAuthNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationOAuthNestedImpl(item);
    }

    public A withKafkaClientAuthenticationTls(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls kafkaClientAuthenticationTls) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationTls!=null){ this.authentication= new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder(kafkaClientAuthenticationTls); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationTlsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl.KafkaClientAuthenticationTlsNestedImpl(item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaMirrorMaker2ClusterSpecFluentImpl that = (KafkaMirrorMaker2ClusterSpecFluentImpl) o;
        if (alias != null ? !alias.equals(that.alias) :that.alias != null) return false;
        if (bootstrapServers != null ? !bootstrapServers.equals(that.bootstrapServers) :that.bootstrapServers != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
        if (authentication != null ? !authentication.equals(that.authentication) :that.authentication != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(alias,  bootstrapServers,  config,  tls,  authentication,  super.hashCode());
    }

      
  /**
   * Represent the TLS configuration for all the Clients(KafkaConnect, KafkaBridge, KafkaMirrorMaker, KafkaMirrorMaker2).
   */
  public class TlsNestedImpl<N> extends io.strimzi.api.kafka.model.ClientTlsFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.TlsNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ClientTlsBuilder builder;

            TlsNestedImpl(io.strimzi.api.kafka.model.ClientTls item) {
                this.builder = new io.strimzi.api.kafka.model.ClientTlsBuilder(this, item);
                        
            }

            TlsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ClientTlsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2ClusterSpecFluentImpl.this.withTls(builder.build());
            }

            public N endTls() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_512 in client based components
   */
  public class KafkaClientAuthenticationScramSha512NestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder builder;

            KafkaClientAuthenticationScramSha512NestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder(this, item);
                        
            }

            KafkaClientAuthenticationScramSha512NestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2ClusterSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationScramSha512() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_256 in client based components
   */
  public class KafkaClientAuthenticationScramSha256NestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256FluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha256Nested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha256Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder builder;

            KafkaClientAuthenticationScramSha256NestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder(this, item);
                        
            }

            KafkaClientAuthenticationScramSha256NestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2ClusterSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationScramSha256() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using SASL PLAIN in client based components
   */
  public class KafkaClientAuthenticationPlainNestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationPlainNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationPlainNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder builder;

            KafkaClientAuthenticationPlainNestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder(this, item);
                        
            }

            KafkaClientAuthenticationPlainNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2ClusterSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationPlain() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using SASl OAUTHBEARER mechanism in client based components
   */
  public class KafkaClientAuthenticationOAuthNestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationOAuthNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationOAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder builder;

            KafkaClientAuthenticationOAuthNestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder(this, item);
                        
            }

            KafkaClientAuthenticationOAuthNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2ClusterSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationOAuth() {
                return and();
            }
    }


      
  /**
   * Configures the Kafka client authentication using TLS client authentication in client based components
   */
  public class KafkaClientAuthenticationTlsNestedImpl<N> extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationTlsNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationTlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder builder;

            KafkaClientAuthenticationTlsNestedImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls item) {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder(this, item);
                        
            }

            KafkaClientAuthenticationTlsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2ClusterSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationTls() {
                return and();
            }
    }


}
