package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2MirrorSpecBuilder extends io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec,io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaMirrorMaker2MirrorSpecBuilder() {
        this(true);
    }

    public KafkaMirrorMaker2MirrorSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaMirrorMaker2MirrorSpec(), validationEnabled);
    }

    public KafkaMirrorMaker2MirrorSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMaker2MirrorSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMaker2MirrorSpec(), validationEnabled);
    }

    public KafkaMirrorMaker2MirrorSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMaker2MirrorSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSourceCluster(instance.getSourceCluster());
        
        fluent.withTargetCluster(instance.getTargetCluster());
        
        fluent.withSourceConnector(instance.getSourceConnector());
        
        fluent.withCheckpointConnector(instance.getCheckpointConnector());
        
        fluent.withHeartbeatConnector(instance.getHeartbeatConnector());
        
        fluent.withTopicsPattern(instance.getTopicsPattern());
        
        fluent.withTopicsBlacklistPattern(instance.getTopicsBlacklistPattern());
        
        fluent.withTopicsExcludePattern(instance.getTopicsExcludePattern());
        
        fluent.withGroupsPattern(instance.getGroupsPattern());
        
        fluent.withGroupsBlacklistPattern(instance.getGroupsBlacklistPattern());
        
        fluent.withGroupsExcludePattern(instance.getGroupsExcludePattern());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2MirrorSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec instance) {
        this(instance,true);
    }

    public KafkaMirrorMaker2MirrorSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSourceCluster(instance.getSourceCluster());
        
        this.withTargetCluster(instance.getTargetCluster());
        
        this.withSourceConnector(instance.getSourceConnector());
        
        this.withCheckpointConnector(instance.getCheckpointConnector());
        
        this.withHeartbeatConnector(instance.getHeartbeatConnector());
        
        this.withTopicsPattern(instance.getTopicsPattern());
        
        this.withTopicsBlacklistPattern(instance.getTopicsBlacklistPattern());
        
        this.withTopicsExcludePattern(instance.getTopicsExcludePattern());
        
        this.withGroupsPattern(instance.getGroupsPattern());
        
        this.withGroupsBlacklistPattern(instance.getGroupsBlacklistPattern());
        
        this.withGroupsExcludePattern(instance.getGroupsExcludePattern());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec build() {
        KafkaMirrorMaker2MirrorSpec buildable = new KafkaMirrorMaker2MirrorSpec();
        buildable.setSourceCluster(fluent.getSourceCluster());
        buildable.setTargetCluster(fluent.getTargetCluster());
        buildable.setSourceConnector(fluent.getSourceConnector());
        buildable.setCheckpointConnector(fluent.getCheckpointConnector());
        buildable.setHeartbeatConnector(fluent.getHeartbeatConnector());
        buildable.setTopicsPattern(fluent.getTopicsPattern());
        buildable.setTopicsBlacklistPattern(fluent.getTopicsBlacklistPattern());
        buildable.setTopicsExcludePattern(fluent.getTopicsExcludePattern());
        buildable.setGroupsPattern(fluent.getGroupsPattern());
        buildable.setGroupsBlacklistPattern(fluent.getGroupsBlacklistPattern());
        buildable.setGroupsExcludePattern(fluent.getGroupsExcludePattern());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2MirrorSpecBuilder that = (KafkaMirrorMaker2MirrorSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
