package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class KafkaMirrorMaker2SpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent<A>> extends io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl<A> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent<A> {

    private java.util.List<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder> clusters;
    private java.lang.String connectCluster;
    private java.util.List<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder> mirrors;

    public KafkaMirrorMaker2SpecFluentImpl() {
    }

    public KafkaMirrorMaker2SpecFluentImpl(io.strimzi.api.kafka.model.KafkaMirrorMaker2Spec instance) {
        this.withClusters(instance.getClusters());
        
        this.withConnectCluster(instance.getConnectCluster());
        
        this.withMirrors(instance.getMirrors());
        
        this.withLogging(instance.getLogging());
        
        this.withReplicas(instance.getReplicas());
        
        this.withVersion(instance.getVersion());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJmxOptions(instance.getJmxOptions());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withTracing(instance.getTracing());
        
        this.withTemplate(instance.getTemplate());
        
        this.withExternalConfiguration(instance.getExternalConfiguration());
    }

    public A addToClusters(int index,io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item) {
        if (this.clusters == null) {this.clusters = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder>();}
        io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").add(index >= 0 ? index : _visitables.get("clusters").size(), builder);this.clusters.add(index >= 0 ? index : clusters.size(), builder); return (A)this;
    }

    public A setToClusters(int index,io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item) {
        if (this.clusters == null) {this.clusters = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder>();}
        io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("clusters").size()) { _visitables.get("clusters").add(builder); } else { _visitables.get("clusters").set(index, builder);}
        if (index < 0 || index >= clusters.size()) { clusters.add(builder); } else { clusters.set(index, builder);}
         return (A)this;
    }

    public A addToClusters(io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec... items) {
        if (this.clusters == null) {this.clusters = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder>();}
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item : items) {io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
    }

    public A addAllToClusters(java.util.Collection<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec> items) {
        if (this.clusters == null) {this.clusters = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder>();}
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item : items) {io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
    }

    public A removeFromClusters(io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec... items) {
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item : items) {io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusters(java.util.Collection<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec> items) {
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item : items) {io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusters(java.util.function.Predicate<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        if (clusters == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder> each = clusters.iterator();
        final List visitables = _visitables.get("clusters");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClusters instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec> getClusters() {
        return build(clusters);
    }

    public java.util.List<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec> buildClusters() {
        return build(clusters);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec buildCluster(int index) {
        return this.clusters.get(index).build();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec buildFirstCluster() {
        return this.clusters.get(0).build();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec buildLastCluster() {
        return this.clusters.get(clusters.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec buildMatchingCluster(java.util.function.Predicate<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder item: clusters) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCluster(java.util.function.Predicate<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder item: clusters) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withClusters(java.util.List<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec> clusters) {
        if (this.clusters != null) { _visitables.get("clusters").removeAll(this.clusters);}
        if (clusters != null) {this.clusters = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder>(); for (io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item : clusters){this.addToClusters(item);}} else { this.clusters = null;} return (A) this;
    }

    public A withClusters(io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec... clusters) {
        if (this.clusters != null) {this.clusters.clear();}
        if (clusters != null) {for (io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item :clusters){ this.addToClusters(item);}} return (A) this;
    }

    public java.lang.Boolean hasClusters() {
        return clusters != null && !clusters.isEmpty();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.ClustersNested<A> addNewCluster() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluentImpl.ClustersNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.ClustersNested<A> addNewClusterLike(io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluentImpl.ClustersNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.ClustersNested<A> setNewClusterLike(int index,io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluentImpl.ClustersNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.ClustersNested<A> editCluster(int index) {
        if (clusters.size() <= index) throw new RuntimeException("Can't edit clusters. Index exceeds size.");
        return setNewClusterLike(index, buildCluster(index));
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.ClustersNested<A> editFirstCluster() {
        if (clusters.size() == 0) throw new RuntimeException("Can't edit first clusters. The list is empty.");
        return setNewClusterLike(0, buildCluster(0));
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.ClustersNested<A> editLastCluster() {
        int index = clusters.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last clusters. The list is empty.");
        return setNewClusterLike(index, buildCluster(index));
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.ClustersNested<A> editMatchingCluster(java.util.function.Predicate<io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<clusters.size();i++) { 
        if (predicate.test(clusters.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching clusters. No match found.");
        return setNewClusterLike(index, buildCluster(index));
    }

    public java.lang.String getConnectCluster() {
        return this.connectCluster;
    }

    public A withConnectCluster(java.lang.String connectCluster) {
        this.connectCluster=connectCluster; return (A) this;
    }

    public java.lang.Boolean hasConnectCluster() {
        return this.connectCluster != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withConnectCluster instead.
     */
        public A withNewConnectCluster(java.lang.String original) {
        return (A)withConnectCluster(new String(original));
    }

    public A addToMirrors(int index,io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item) {
        if (this.mirrors == null) {this.mirrors = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder>();}
        io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").add(index >= 0 ? index : _visitables.get("mirrors").size(), builder);this.mirrors.add(index >= 0 ? index : mirrors.size(), builder); return (A)this;
    }

    public A setToMirrors(int index,io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item) {
        if (this.mirrors == null) {this.mirrors = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder>();}
        io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("mirrors").size()) { _visitables.get("mirrors").add(builder); } else { _visitables.get("mirrors").set(index, builder);}
        if (index < 0 || index >= mirrors.size()) { mirrors.add(builder); } else { mirrors.set(index, builder);}
         return (A)this;
    }

    public A addToMirrors(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec... items) {
        if (this.mirrors == null) {this.mirrors = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder>();}
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item : items) {io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").add(builder);this.mirrors.add(builder);} return (A)this;
    }

    public A addAllToMirrors(java.util.Collection<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec> items) {
        if (this.mirrors == null) {this.mirrors = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder>();}
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item : items) {io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").add(builder);this.mirrors.add(builder);} return (A)this;
    }

    public A removeFromMirrors(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec... items) {
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item : items) {io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").remove(builder);if (this.mirrors != null) {this.mirrors.remove(builder);}} return (A)this;
    }

    public A removeAllFromMirrors(java.util.Collection<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec> items) {
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item : items) {io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").remove(builder);if (this.mirrors != null) {this.mirrors.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMirrors(java.util.function.Predicate<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        if (mirrors == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder> each = mirrors.iterator();
        final List visitables = _visitables.get("mirrors");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMirrors instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec> getMirrors() {
        return build(mirrors);
    }

    public java.util.List<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec> buildMirrors() {
        return build(mirrors);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec buildMirror(int index) {
        return this.mirrors.get(index).build();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec buildFirstMirror() {
        return this.mirrors.get(0).build();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec buildLastMirror() {
        return this.mirrors.get(mirrors.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec buildMatchingMirror(java.util.function.Predicate<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder item: mirrors) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingMirror(java.util.function.Predicate<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        for (io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder item: mirrors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMirrors(java.util.List<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec> mirrors) {
        if (this.mirrors != null) { _visitables.get("mirrors").removeAll(this.mirrors);}
        if (mirrors != null) {this.mirrors = new java.util.ArrayList<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder>(); for (io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item : mirrors){this.addToMirrors(item);}} else { this.mirrors = null;} return (A) this;
    }

    public A withMirrors(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec... mirrors) {
        if (this.mirrors != null) {this.mirrors.clear();}
        if (mirrors != null) {for (io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item :mirrors){ this.addToMirrors(item);}} return (A) this;
    }

    public java.lang.Boolean hasMirrors() {
        return mirrors != null && !mirrors.isEmpty();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.MirrorsNested<A> addNewMirror() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluentImpl.MirrorsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.MirrorsNested<A> addNewMirrorLike(io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluentImpl.MirrorsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.MirrorsNested<A> setNewMirrorLike(int index,io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluentImpl.MirrorsNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editMirror(int index) {
        if (mirrors.size() <= index) throw new RuntimeException("Can't edit mirrors. Index exceeds size.");
        return setNewMirrorLike(index, buildMirror(index));
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editFirstMirror() {
        if (mirrors.size() == 0) throw new RuntimeException("Can't edit first mirrors. The list is empty.");
        return setNewMirrorLike(0, buildMirror(0));
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editLastMirror() {
        int index = mirrors.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last mirrors. The list is empty.");
        return setNewMirrorLike(index, buildMirror(index));
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editMatchingMirror(java.util.function.Predicate<io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<mirrors.size();i++) { 
        if (predicate.test(mirrors.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching mirrors. No match found.");
        return setNewMirrorLike(index, buildMirror(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2SpecFluentImpl that = (KafkaMirrorMaker2SpecFluentImpl) o;
        if (clusters != null ? !clusters.equals(that.clusters) :that.clusters != null) return false;
        if (connectCluster != null ? !connectCluster.equals(that.connectCluster) :that.connectCluster != null) return false;
        if (mirrors != null ? !mirrors.equals(that.mirrors) :that.mirrors != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clusters,  connectCluster,  mirrors,  super.hashCode());
    }

    public class ClustersNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.ClustersNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.ClustersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder builder;
        private final int index;

            ClustersNestedImpl(int index,io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder(this, item);
                        
            }

            ClustersNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2SpecFluentImpl.this.setToClusters(index,builder.build());
            }

            public N endCluster() {
                return and();
            }
    }


    public class MirrorsNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.MirrorsNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent.MirrorsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder builder;
        private final int index;

            MirrorsNestedImpl(int index,io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder(this, item);
                        
            }

            MirrorsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2SpecFluentImpl.this.setToMirrors(index,builder.build());
            }

            public N endMirror() {
                return and();
            }
    }


}
