package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerBuilder extends io.strimzi.api.kafka.model.KafkaMirrorMakerFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaMirrorMaker,io.strimzi.api.kafka.model.KafkaMirrorMakerBuilder> {

    io.strimzi.api.kafka.model.KafkaMirrorMakerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaMirrorMakerBuilder() {
        this(true);
    }

    public KafkaMirrorMakerBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaMirrorMaker(), validationEnabled);
    }

    public KafkaMirrorMakerBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMaker(), validationEnabled);
    }

    public KafkaMirrorMakerBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMaker instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMaker instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withKind(instance.getKind());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerBuilder(io.strimzi.api.kafka.model.KafkaMirrorMaker instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerBuilder(io.strimzi.api.kafka.model.KafkaMirrorMaker instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMaker build() {
        KafkaMirrorMaker buildable = new KafkaMirrorMaker();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerBuilder that = (KafkaMirrorMakerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
