package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerClientSpecBuilder extends io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpec,io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaMirrorMakerClientSpecBuilder() {
        this(true);
    }

    public KafkaMirrorMakerClientSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaMirrorMakerClientSpec(), validationEnabled);
    }

    public KafkaMirrorMakerClientSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerClientSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMakerClientSpec(), validationEnabled);
    }

    public KafkaMirrorMakerClientSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerClientSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBootstrapServers(instance.getBootstrapServers());
        
        fluent.withConfig(instance.getConfig());
        
        fluent.withTls(instance.getTls());
        
        fluent.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerClientSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpec instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerClientSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withConfig(instance.getConfig());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpec build() {
        KafkaMirrorMakerClientSpec buildable = new KafkaMirrorMakerClientSpec();
        buildable.setBootstrapServers(fluent.getBootstrapServers());
        buildable.setConfig(fluent.getConfig());
        buildable.setTls(fluent.getTls());
        buildable.setAuthentication(fluent.getAuthentication());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerClientSpecBuilder that = (KafkaMirrorMakerClientSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
