package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder;
import java.lang.Object;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent;
import java.util.Map;

public interface KafkaMirrorMakerClientSpecFluent<A extends io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getBootstrapServers();
    public A withBootstrapServers(java.lang.String bootstrapServers);
    public java.lang.Boolean hasBootstrapServers();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBootstrapServers instead.
     */
        public A withNewBootstrapServers(java.lang.String original);
    public A addToConfig(java.lang.String key,java.lang.Object value);
    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public A removeFromConfig(java.lang.String key);
    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public java.util.Map<java.lang.String,java.lang.Object> getConfig();
    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config);
    public java.lang.Boolean hasConfig();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTls instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.ClientTls getTls();
    public io.strimzi.api.kafka.model.ClientTls buildTls();
    public A withTls(io.strimzi.api.kafka.model.ClientTls tls);
    public java.lang.Boolean hasTls();
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.TlsNested<A> withNewTls();
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.TlsNested<A> withNewTlsLike(io.strimzi.api.kafka.model.ClientTls item);
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.TlsNested<A> editTls();
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.TlsNested<A> editOrNewTls();
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.TlsNested<A> editOrNewTlsLike(io.strimzi.api.kafka.model.ClientTls item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuthentication instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication getAuthentication();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication buildAuthentication();
    public A withAuthentication(io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication authentication);
    public java.lang.Boolean hasAuthentication();
    public A withKafkaClientAuthenticationScramSha512(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512);
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512();
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 item);
    public A withKafkaClientAuthenticationScramSha256(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 kafkaClientAuthenticationScramSha256);
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256();
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 item);
    public A withKafkaClientAuthenticationPlain(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain);
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain();
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain item);
    public A withKafkaClientAuthenticationOAuth(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth);
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth();
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth item);
    public A withKafkaClientAuthenticationTls(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls kafkaClientAuthenticationTls);
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls();
    public io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls item);
      
  /**
   * Represent the TLS configuration for all the Clients(KafkaConnect, KafkaBridge, KafkaMirrorMaker, KafkaMirrorMaker2).
   */
  public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ClientTlsFluent<io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.TlsNested<N>> {

            public N and();
            public N endTls();    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_512 in client based components
   */
  public interface KafkaClientAuthenticationScramSha512Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>> {

            public N and();
            public N endKafkaClientAuthenticationScramSha512();    }


      
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_256 in client based components
   */
  public interface KafkaClientAuthenticationScramSha256Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent<io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha256Nested<N>> {

            public N and();
            public N endKafkaClientAuthenticationScramSha256();    }


      
  /**
   * Configures the Kafka client authentication using SASL PLAIN in client based components
   */
  public interface KafkaClientAuthenticationPlainNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent<io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationPlain();    }


      
  /**
   * Configures the Kafka client authentication using SASl OAUTHBEARER mechanism in client based components
   */
  public interface KafkaClientAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationOAuth();    }


      
  /**
   * Configures the Kafka client authentication using TLS client authentication in client based components
   */
  public interface KafkaClientAuthenticationTlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<N>> {

            public N and();
            public N endKafkaClientAuthenticationTls();    }


}
