package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerConsumerSpecBuilder extends io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec,io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaMirrorMakerConsumerSpecBuilder() {
        this(true);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaMirrorMakerConsumerSpec(), validationEnabled);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMakerConsumerSpec(), validationEnabled);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNumStreams(instance.getNumStreams());
        
        fluent.withGroupId(instance.getGroupId());
        
        fluent.withOffsetCommitInterval(instance.getOffsetCommitInterval());
        
        fluent.withBootstrapServers(instance.getBootstrapServers());
        
        fluent.withConfig(instance.getConfig());
        
        fluent.withTls(instance.getTls());
        
        fluent.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerConsumerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withNumStreams(instance.getNumStreams());
        
        this.withGroupId(instance.getGroupId());
        
        this.withOffsetCommitInterval(instance.getOffsetCommitInterval());
        
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withConfig(instance.getConfig());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec build() {
        KafkaMirrorMakerConsumerSpec buildable = new KafkaMirrorMakerConsumerSpec();
        buildable.setBootstrapServers(fluent.getBootstrapServers());
        buildable.setConfig(fluent.getConfig());
        buildable.setTls(fluent.getTls());
        buildable.setAuthentication(fluent.getAuthentication());
        buildable.setNumStreams(fluent.getNumStreams());
        buildable.setGroupId(fluent.getGroupId());
        buildable.setOffsetCommitInterval(fluent.getOffsetCommitInterval());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerConsumerSpecBuilder that = (KafkaMirrorMakerConsumerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
