package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus;
import io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerFluentImpl<A extends io.strimzi.api.kafka.model.KafkaMirrorMakerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaMirrorMakerFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private io.strimzi.api.kafka.model.KafkaMirrorMakerSpecBuilder spec;
    private io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder status;

    public KafkaMirrorMakerFluentImpl() {
    }

    public KafkaMirrorMakerFluentImpl(io.strimzi.api.kafka.model.KafkaMirrorMaker instance) {
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String original) {
        return (A)withApiVersion(new String(original));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String original) {
        return (A)withKind(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.MetadataNested<A> withNewMetadata() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerFluentImpl.MetadataNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerFluentImpl.MetadataNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSpec instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaMirrorMakerSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(io.strimzi.api.kafka.model.KafkaMirrorMakerSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public java.lang.Boolean hasSpec() {
        return this.spec != null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.SpecNested<A> withNewSpec() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerFluentImpl.SpecNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.SpecNested<A> withNewSpecLike(io.strimzi.api.kafka.model.KafkaMirrorMakerSpec item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerFluentImpl.SpecNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.SpecNested<A> editOrNewSpecLike(io.strimzi.api.kafka.model.KafkaMirrorMakerSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStatus instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public java.lang.Boolean hasStatus() {
        return this.status != null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.StatusNested<A> withNewStatus() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerFluentImpl.StatusNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.StatusNested<A> withNewStatusLike(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerFluentImpl.StatusNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.StatusNested<A> editOrNewStatusLike(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaMirrorMakerFluentImpl that = (KafkaMirrorMakerFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.MetadataNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.SpecNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaMirrorMakerSpecBuilder builder;

            SpecNestedImpl(io.strimzi.api.kafka.model.KafkaMirrorMakerSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


      
  /**
   * Represents a status of the Kafka MirrorMaker resource
   */
  public class StatusNestedImpl<N> extends io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.StatusNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder builder;

            StatusNestedImpl(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus item) {
                this.builder = new io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
