package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerSpecBuilder extends io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaMirrorMakerSpec,io.strimzi.api.kafka.model.KafkaMirrorMakerSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaMirrorMakerSpecBuilder() {
        this(true);
    }

    public KafkaMirrorMakerSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaMirrorMakerSpec(), validationEnabled);
    }

    public KafkaMirrorMakerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMakerSpec(), validationEnabled);
    }

    public KafkaMirrorMakerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMakerSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaMirrorMakerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withVersion(instance.getVersion());
        
        fluent.withImage(instance.getImage());
        
        fluent.withWhitelist(instance.getWhitelist());
        
        fluent.withInclude(instance.getInclude());
        
        fluent.withConsumer(instance.getConsumer());
        
        fluent.withProducer(instance.getProducer());
        
        fluent.withResources(instance.getResources());
        
        fluent.withLivenessProbe(instance.getLivenessProbe());
        
        fluent.withReadinessProbe(instance.getReadinessProbe());
        
        fluent.withJvmOptions(instance.getJvmOptions());
        
        fluent.withLogging(instance.getLogging());
        
        fluent.withMetricsConfig(instance.getMetricsConfig());
        
        fluent.withTracing(instance.getTracing());
        
        fluent.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerSpec instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerSpecBuilder(io.strimzi.api.kafka.model.KafkaMirrorMakerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withReplicas(instance.getReplicas());
        
        this.withVersion(instance.getVersion());
        
        this.withImage(instance.getImage());
        
        this.withWhitelist(instance.getWhitelist());
        
        this.withInclude(instance.getInclude());
        
        this.withConsumer(instance.getConsumer());
        
        this.withProducer(instance.getProducer());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withLogging(instance.getLogging());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withTracing(instance.getTracing());
        
        this.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpec build() {
        KafkaMirrorMakerSpec buildable = new KafkaMirrorMakerSpec();
        buildable.setReplicas(fluent.getReplicas());
        buildable.setVersion(fluent.getVersion());
        buildable.setImage(fluent.getImage());
        buildable.setWhitelist(fluent.getWhitelist());
        buildable.setInclude(fluent.getInclude());
        buildable.setConsumer(fluent.getConsumer());
        buildable.setProducer(fluent.getProducer());
        buildable.setResources(fluent.getResources());
        buildable.setLivenessProbe(fluent.getLivenessProbe());
        buildable.setReadinessProbe(fluent.getReadinessProbe());
        buildable.setJvmOptions(fluent.getJvmOptions());
        buildable.setLogging(fluent.getLogging());
        buildable.setMetricsConfig(fluent.getMetricsConfig());
        buildable.setTracing(fluent.getTracing());
        buildable.setTemplate(fluent.getTemplate());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerSpecBuilder that = (KafkaMirrorMakerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
