package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.String;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Boolean;
import java.lang.Object;
import io.strimzi.api.kafka.model.tracing.Tracing;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluentImpl;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluentImpl;

public class KafkaMirrorMakerSpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluentImpl<A> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent<A> {

    private int replicas;
    private java.lang.String version;
    private java.lang.String image;
    private java.lang.String whitelist;
    private java.lang.String include;
    private io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecBuilder consumer;
    private io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpecBuilder producer;
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    private io.strimzi.api.kafka.model.ProbeBuilder livenessProbe;
    private io.strimzi.api.kafka.model.ProbeBuilder readinessProbe;
    private io.strimzi.api.kafka.model.JvmOptionsBuilder jvmOptions;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.Logging,?> logging;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.MetricsConfig,?> metricsConfig;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.tracing.Tracing,?> tracing;
    private io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder template;

    public KafkaMirrorMakerSpecFluentImpl() {
    }

    public KafkaMirrorMakerSpecFluentImpl(io.strimzi.api.kafka.model.KafkaMirrorMakerSpec instance) {
        this.withReplicas(instance.getReplicas());
        
        this.withVersion(instance.getVersion());
        
        this.withImage(instance.getImage());
        
        this.withWhitelist(instance.getWhitelist());
        
        this.withInclude(instance.getInclude());
        
        this.withConsumer(instance.getConsumer());
        
        this.withProducer(instance.getProducer());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withLogging(instance.getLogging());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withTracing(instance.getTracing());
        
        this.withTemplate(instance.getTemplate());
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return true;
    }

    public java.lang.String getVersion() {
        return this.version;
    }

    public A withVersion(java.lang.String version) {
        this.version=version; return (A) this;
    }

    public java.lang.Boolean hasVersion() {
        return this.version != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVersion instead.
     */
        public A withNewVersion(java.lang.String original) {
        return (A)withVersion(new String(original));
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original) {
        return (A)withImage(new String(original));
    }

    public java.lang.String getWhitelist() {
        return this.whitelist;
    }

    public A withWhitelist(java.lang.String whitelist) {
        this.whitelist=whitelist; return (A) this;
    }

    public java.lang.Boolean hasWhitelist() {
        return this.whitelist != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withWhitelist instead.
     */
        public A withNewWhitelist(java.lang.String original) {
        return (A)withWhitelist(new String(original));
    }

    public java.lang.String getInclude() {
        return this.include;
    }

    public A withInclude(java.lang.String include) {
        this.include=include; return (A) this;
    }

    public java.lang.Boolean hasInclude() {
        return this.include != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withInclude instead.
     */
        public A withNewInclude(java.lang.String original) {
        return (A)withInclude(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConsumer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec getConsumer() {
        return this.consumer!=null?this.consumer.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec buildConsumer() {
        return this.consumer!=null?this.consumer.build():null;
    }

    public A withConsumer(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec consumer) {
        _visitables.get("consumer").remove(this.consumer);
        if (consumer!=null){ this.consumer= new io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecBuilder(consumer); _visitables.get("consumer").add(this.consumer);} return (A) this;
    }

    public java.lang.Boolean hasConsumer() {
        return this.consumer != null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ConsumerNested<A> withNewConsumer() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.ConsumerNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ConsumerNested<A> withNewConsumerLike(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.ConsumerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ConsumerNested<A> editConsumer() {
        return withNewConsumerLike(getConsumer());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ConsumerNested<A> editOrNewConsumer() {
        return withNewConsumerLike(getConsumer() != null ? getConsumer(): new io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ConsumerNested<A> editOrNewConsumerLike(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec item) {
        return withNewConsumerLike(getConsumer() != null ? getConsumer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildProducer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpec getProducer() {
        return this.producer!=null?this.producer.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpec buildProducer() {
        return this.producer!=null?this.producer.build():null;
    }

    public A withProducer(io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpec producer) {
        _visitables.get("producer").remove(this.producer);
        if (producer!=null){ this.producer= new io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpecBuilder(producer); _visitables.get("producer").add(this.producer);} return (A) this;
    }

    public java.lang.Boolean hasProducer() {
        return this.producer != null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ProducerNested<A> withNewProducer() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.ProducerNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ProducerNested<A> withNewProducerLike(io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpec item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.ProducerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ProducerNested<A> editProducer() {
        return withNewProducerLike(getProducer());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ProducerNested<A> editOrNewProducer() {
        return withNewProducerLike(getProducer() != null ? getProducer(): new io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ProducerNested<A> editOrNewProducerLike(io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpec item) {
        return withNewProducerLike(getProducer() != null ? getProducer(): item);
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public java.lang.Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.LivenessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.LivenessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public java.lang.Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.ReadinessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.ReadinessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJvmOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JvmOptions getJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public io.strimzi.api.kafka.model.JvmOptions buildJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(io.strimzi.api.kafka.model.JvmOptions jvmOptions) {
        _visitables.get("jvmOptions").remove(this.jvmOptions);
        if (jvmOptions!=null){ this.jvmOptions= new io.strimzi.api.kafka.model.JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public java.lang.Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.JvmOptionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.JvmOptionsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new io.strimzi.api.kafka.model.JvmOptionsBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Logging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public io.strimzi.api.kafka.model.Logging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(io.strimzi.api.kafka.model.Logging logging) {
        if (logging instanceof io.strimzi.api.kafka.model.ExternalLogging){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder((io.strimzi.api.kafka.model.ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
        if (logging instanceof io.strimzi.api.kafka.model.InlineLogging){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder((io.strimzi.api.kafka.model.InlineLogging)logging); _visitables.get("logging").add(this.logging);}
        return (A) this;
    }

    public java.lang.Boolean hasLogging() {
        return this.logging != null;
    }

    public A withExternalLogging(io.strimzi.api.kafka.model.ExternalLogging externalLogging) {
        _visitables.get("logging").remove(this.logging);
        if (externalLogging!=null){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.ExternalLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(io.strimzi.api.kafka.model.ExternalLogging item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(io.strimzi.api.kafka.model.InlineLogging inlineLogging) {
        _visitables.get("logging").remove(this.logging);
        if (inlineLogging!=null){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.InlineLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(io.strimzi.api.kafka.model.InlineLogging item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.InlineLoggingNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetricsConfig instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.MetricsConfig getMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public io.strimzi.api.kafka.model.MetricsConfig buildMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public A withMetricsConfig(io.strimzi.api.kafka.model.MetricsConfig metricsConfig) {
        if (metricsConfig instanceof io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder((io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics)metricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);}
        return (A) this;
    }

    public java.lang.Boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public A withJmxPrometheusExporterMetricsConfig(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig) {
        _visitables.get("metricsConfig").remove(this.metricsConfig);
        if (jmxPrometheusExporterMetricsConfig!=null){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTracing instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.tracing.Tracing getTracing() {
        return this.tracing!=null?this.tracing.build():null;
    }

    public io.strimzi.api.kafka.model.tracing.Tracing buildTracing() {
        return this.tracing!=null?this.tracing.build():null;
    }

    public A withTracing(io.strimzi.api.kafka.model.tracing.Tracing tracing) {
        if (tracing instanceof io.strimzi.api.kafka.model.tracing.JaegerTracing){ this.tracing= new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder((io.strimzi.api.kafka.model.tracing.JaegerTracing)tracing); _visitables.get("tracing").add(this.tracing);}
        return (A) this;
    }

    public java.lang.Boolean hasTracing() {
        return this.tracing != null;
    }

    public A withJaegerTracing(io.strimzi.api.kafka.model.tracing.JaegerTracing jaegerTracing) {
        _visitables.get("tracing").remove(this.tracing);
        if (jaegerTracing!=null){ this.tracing= new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder(jaegerTracing); _visitables.get("tracing").add(this.tracing);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JaegerTracingNested<A> withNewJaegerTracing() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.JaegerTracingNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(io.strimzi.api.kafka.model.tracing.JaegerTracing item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.JaegerTracingNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate item) {
        return new io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerSpecFluentImpl that = (KafkaMirrorMakerSpecFluentImpl) o;
        if (replicas != that.replicas) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (whitelist != null ? !whitelist.equals(that.whitelist) :that.whitelist != null) return false;
        if (include != null ? !include.equals(that.include) :that.include != null) return false;
        if (consumer != null ? !consumer.equals(that.consumer) :that.consumer != null) return false;
        if (producer != null ? !producer.equals(that.producer) :that.producer != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (metricsConfig != null ? !metricsConfig.equals(that.metricsConfig) :that.metricsConfig != null) return false;
        if (tracing != null ? !tracing.equals(that.tracing) :that.tracing != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(replicas,  version,  image,  whitelist,  include,  consumer,  producer,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  logging,  metricsConfig,  tracing,  template,  super.hashCode());
    }

    public class ConsumerNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ConsumerNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ConsumerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecBuilder builder;

            ConsumerNestedImpl(io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecBuilder(this, item);
                        
            }

            ConsumerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withConsumer(builder.build());
            }

            public N endConsumer() {
                return and();
            }
    }


    public class ProducerNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpecFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ProducerNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ProducerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpecBuilder builder;

            ProducerNestedImpl(io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpecBuilder(this, item);
                        
            }

            ProducerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withProducer(builder.build());
            }

            public N endProducer() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class LivenessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.LivenessProbeNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            LivenessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ReadinessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ReadinessProbeNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            ReadinessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


      
  /**
   * Representation for options to be passed to a JVM.
   */
  public class JvmOptionsNestedImpl<N> extends io.strimzi.api.kafka.model.JvmOptionsFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JvmOptionsNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JvmOptionsBuilder builder;

            JvmOptionsNestedImpl(io.strimzi.api.kafka.model.JvmOptions item) {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this, item);
                        
            }

            JvmOptionsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withJvmOptions(builder.build());
            }

            public N endJvmOptions() {
                return and();
            }
    }


      
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public class ExternalLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.ExternalLoggingFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ExternalLoggingNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ExternalLoggingBuilder builder;

            ExternalLoggingNestedImpl(io.strimzi.api.kafka.model.ExternalLogging item) {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this, item);
                        
            }

            ExternalLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endExternalLogging() {
                return and();
            }
    }


      
  /**
   * Logging config is given inline with the resource
   */
  public class InlineLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.InlineLoggingFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.InlineLoggingNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.InlineLoggingBuilder builder;

            InlineLoggingNestedImpl(io.strimzi.api.kafka.model.InlineLogging item) {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this, item);
                        
            }

            InlineLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endInlineLogging() {
                return and();
            }
    }


      
  /**
   * JMX Prometheus Exporter metrics config
   */
  public class JmxPrometheusExporterMetricsConfigNestedImpl<N> extends io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder builder;

            JmxPrometheusExporterMetricsConfigNestedImpl(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this, item);
                        
            }

            JmxPrometheusExporterMetricsConfigNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withMetricsConfig(builder.build());
            }

            public N endJmxPrometheusExporterMetricsConfig() {
                return and();
            }
    }


      
  /**
   * Configures the tracing using the Jaeger OpenTracing implementation
   */
  public class JaegerTracingNestedImpl<N> extends io.strimzi.api.kafka.model.tracing.JaegerTracingFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JaegerTracingNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.JaegerTracingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder builder;

            JaegerTracingNestedImpl(io.strimzi.api.kafka.model.tracing.JaegerTracing item) {
                this.builder = new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder(this, item);
                        
            }

            JaegerTracingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withTracing(builder.build());
            }

            public N endJaegerTracing() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Kafka MirrorMaker resources.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluentImpl<io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


}
